/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.xsoup;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.select.Evaluator;
import org.jsoup.select.Selector;
import us.codecraft.xsoup.CombingXPathEvaluator;
import us.codecraft.xsoup.CombiningEvaluator;
import us.codecraft.xsoup.DefaultXPathEvaluator;
import us.codecraft.xsoup.ElementOperator;
import us.codecraft.xsoup.StructuralEvaluator;
import us.codecraft.xsoup.XEvaluators;
import us.codecraft.xsoup.XPathEvaluator;
import us.codecraft.xsoup.XTokenQueue;

public class XPathParser {
    private String[] COMBINATORS = new String[]{"//", "/", "|"};
    private String[] HIERARCHY_COMBINATORS = new String[]{"//", "/", "|"};
    private String OR_COMBINATOR = "|";
    private XTokenQueue tq;
    private String query;
    private List<Evaluator> evals = new ArrayList<Evaluator>();
    private ElementOperator elementOperator;
    private boolean noEvalAllow = false;
    private Pattern patternForText = Pattern.compile("text\\((\\d*)\\)");

    public XPathParser(String xpathStr) {
        this.query = xpathStr;
        this.tq = new XTokenQueue(xpathStr);
    }

    public XPathEvaluator parse() {
        while (!this.tq.isEmpty()) {
            Validate.isFalse((boolean)this.noEvalAllow, (String)("XPath error! No operator allowed after attribute or function!" + this.tq));
            if (this.tq.matchChomp(this.OR_COMBINATOR)) {
                this.tq.consumeWhitespace();
                return this.combineXPathEvaluator(this.tq.remainder());
            }
            if (this.tq.matchesAny(this.HIERARCHY_COMBINATORS)) {
                this.combinator(this.tq.consumeAny(this.HIERARCHY_COMBINATORS));
            } else {
                this.findElements();
            }
            this.tq.consumeWhitespace();
        }
        return this.collectXPathEvaluator();
    }

    private XPathEvaluator combineXPathEvaluator(String subQuery) {
        XPathEvaluator xPathEvaluator = this.collectXPathEvaluator();
        return new CombingXPathEvaluator(xPathEvaluator, XPathParser.parse(subQuery));
    }

    private XPathEvaluator collectXPathEvaluator() {
        if (this.noEvalAllow) {
            return new DefaultXPathEvaluator(null, this.elementOperator);
        }
        if (this.evals.size() == 1) {
            return new DefaultXPathEvaluator(this.evals.get(0), this.elementOperator);
        }
        return new DefaultXPathEvaluator(new CombiningEvaluator.And(this.evals), this.elementOperator);
    }

    private void combinator(String combinator) {
        Object currentEval = this.evals.size() == 0 ? new StructuralEvaluator.Root() : (this.evals.size() == 1 ? this.evals.get(0) : new CombiningEvaluator.And(this.evals));
        this.evals.clear();
        String subQuery = this.consumeSubQuery();
        XPathEvaluator tmpEval = XPathParser.parse(subQuery);
        if (!(tmpEval instanceof DefaultXPathEvaluator)) {
            throw new IllegalArgumentException(String.format("Error XPath in %s", subQuery));
        }
        DefaultXPathEvaluator newEval = (DefaultXPathEvaluator)tmpEval;
        if (newEval.getElementOperator() != null) {
            this.elementOperator = newEval.getElementOperator();
        }
        if (newEval.getEvaluator() != null) {
            if (combinator.equals("//")) {
                currentEval = new CombiningEvaluator.And(newEval.getEvaluator(), new StructuralEvaluator.Parent((Evaluator)currentEval));
            } else if (combinator.equals("/")) {
                currentEval = new CombiningEvaluator.And(newEval.getEvaluator(), new StructuralEvaluator.ImmediateParent((Evaluator)currentEval));
            }
        }
        this.evals.add((Evaluator)currentEval);
    }

    private String consumeSubQuery() {
        StringBuilder sq = new StringBuilder();
        while (!this.tq.isEmpty()) {
            this.tq.consumeWhitespace();
            if (this.tq.matches("(")) {
                sq.append("(").append(this.tq.chompBalanced('(', ')')).append(")");
                continue;
            }
            if (this.tq.matches("[")) {
                sq.append("[").append(this.tq.chompBalanced('[', ']')).append("]");
                continue;
            }
            if (this.tq.matchesAny(this.COMBINATORS)) break;
            if (this.tq.isEmpty()) continue;
            sq.append(this.tq.consume());
        }
        return sq.toString();
    }

    private void findElements() {
        if (this.tq.matches("@")) {
            this.consumeAttribute();
        } else if (this.tq.matches("*")) {
            this.allElements();
        } else if (this.tq.matchesRegex("\\w+\\(.*\\).*")) {
            this.consumeOperatorFunction();
        } else if (this.tq.matchesWord()) {
            this.byTag();
        } else if (this.tq.matchesRegex("\\[\\d+\\]")) {
            this.byNth();
        } else if (this.tq.matches("[")) {
            this.evals.add(this.consumePredicates(this.tq.chompBalanced('[', ']')));
        } else {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", new Object[]{this.query, this.tq.remainder()});
        }
    }

    private Evaluator consumePredicates(String queue) {
        XTokenQueue predicatesQueue = new XTokenQueue(queue);
        EvaluatorStack evaluatorStack = new EvaluatorStack();
        Operation currentOperation = null;
        predicatesQueue.consumeWhitespace();
        while (!predicatesQueue.isEmpty()) {
            if (predicatesQueue.matchChomp("and")) {
                currentOperation = Operation.AND;
            } else if (predicatesQueue.matchChomp("or")) {
                currentOperation = Operation.OR;
            } else {
                Evaluator evaluator;
                if (currentOperation == null && evaluatorStack.size() > 0) {
                    throw new IllegalArgumentException(String.format("Need AND/OR between two predicate! %s", predicatesQueue.remainder()));
                }
                if (predicatesQueue.matches("(")) {
                    evaluator = this.consumePredicates(predicatesQueue.chompBalanced('(', ')'));
                } else if (predicatesQueue.matches("@")) {
                    evaluator = this.byAttribute(predicatesQueue);
                } else if (predicatesQueue.matchesRegex("\\w+.*")) {
                    evaluator = this.byFunction(predicatesQueue);
                } else {
                    throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", new Object[]{this.query, predicatesQueue.remainder()});
                }
                evaluatorStack.calc(evaluator, currentOperation);
                currentOperation = null;
            }
            predicatesQueue.consumeWhitespace();
        }
        evaluatorStack.mergeOr();
        return (Evaluator)evaluatorStack.peek();
    }

    private Evaluator byFunction(XTokenQueue predicatesQueue) {
        if (predicatesQueue.matchChomp("contains")) {
            String paramString = predicatesQueue.chompBalanced('(', ')');
            List<String> params = XTokenQueue.trimQuotes(XTokenQueue.parseFuncionParams(paramString));
            Validate.isTrue((params.size() == 2 ? 1 : 0) != 0, (String)String.format("Error argument \"%s\" of contains", paramString));
            if (params.get(0).startsWith("@")) {
                return new Evaluator.AttributeWithValueContaining(params.get(0).substring(1), params.get(1));
            }
        } else {
            throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", new Object[]{this.query, predicatesQueue.remainder()});
        }
        return null;
    }

    private void allElements() {
        this.tq.consume();
        this.evals.add((Evaluator)new Evaluator.AllElements());
    }

    private void byNth() {
        String nth = this.tq.chompBalanced('[', ']');
        this.evals.add((Evaluator)new Evaluator.IsNthOfType(0, Integer.parseInt(nth)));
    }

    private void consumeAttribute() {
        this.tq.consume("@");
        this.elementOperator = new ElementOperator.AttributeGetter(this.tq.remainder());
        this.noEvalAllow = true;
    }

    private void consumeOperatorFunction() {
        String remainder = this.tq.consumeToAny(this.COMBINATORS);
        if (remainder.startsWith("text(")) {
            this.functionText(remainder);
        } else if (remainder.startsWith("regex(")) {
            this.functionRegex(remainder);
        } else if (remainder.equals("allText()")) {
            this.elementOperator = new ElementOperator.AllText();
        } else if (remainder.equals("tidyText()")) {
            this.elementOperator = new ElementOperator.TidyText();
        } else if (remainder.equals("html()")) {
            this.elementOperator = new ElementOperator.Html();
        } else if (remainder.equals("outerHtml()")) {
            this.elementOperator = new ElementOperator.OuterHtml();
        } else {
            throw new IllegalArgumentException("Unsupported function " + remainder);
        }
        if (this.elementOperator != null) {
            this.noEvalAllow = true;
        }
    }

    private void functionRegex(String remainder) {
        Validate.isTrue((boolean)remainder.endsWith(")"), (String)("Unclosed bracket for function! " + remainder));
        List<String> params = XTokenQueue.trimQuotes(XTokenQueue.parseFuncionParams(remainder.substring("regex(".length(), remainder.length() - 1)));
        if (params.size() == 1) {
            this.elementOperator = new ElementOperator.Regex(params.get(0));
        } else if (params.size() == 2) {
            this.elementOperator = params.get(0).startsWith("@") ? new ElementOperator.Regex(params.get(1), params.get(0).substring(1)) : new ElementOperator.Regex(params.get(0), null, Integer.parseInt(params.get(1)));
        } else if (params.size() == 3) {
            this.elementOperator = new ElementOperator.Regex(params.get(1), params.get(0).substring(1), Integer.parseInt(params.get(2)));
        } else {
            throw new Selector.SelectorParseException("Unknown usage for regex()" + remainder, new Object[0]);
        }
    }

    private void functionText(String remainder) {
        Matcher matcher = this.patternForText.matcher(remainder);
        if (matcher.matches()) {
            String group = matcher.group(1);
            int attributeGroup = group.equals("") ? 0 : Integer.parseInt(group);
            this.elementOperator = new ElementOperator.GroupedText(attributeGroup);
        }
    }

    private void byTag() {
        String tagName = this.tq.consumeElementSelector();
        Validate.notEmpty((String)tagName);
        if (tagName.contains("|")) {
            tagName = tagName.replace("|", ":");
        }
        this.evals.add((Evaluator)new Evaluator.Tag(tagName.trim().toLowerCase()));
    }

    private Evaluator byAttribute(XTokenQueue cq) {
        Object evaluator;
        cq.matchChomp("@");
        String key = cq.consumeToAny("=", "!=", "^=", "$=", "*=", "~=");
        Validate.notEmpty((String)key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            evaluator = "*".equals(key) ? new XEvaluators.HasAnyAttribute() : new Evaluator.Attribute(key);
        } else if (cq.matchChomp("=")) {
            String className;
            String value = this.chompEqualValue(cq);
            evaluator = key.equals("class") ? (!(className = XTokenQueue.trimQuotes(value)).contains(" ") ? new Evaluator.Class(className) : new Evaluator.AttributeWithValue(key, className)) : new Evaluator.AttributeWithValue(key, XTokenQueue.trimQuotes(value));
        } else if (cq.matchChomp("!=")) {
            evaluator = new Evaluator.AttributeWithValueNot(key, XTokenQueue.trimQuotes(this.chompEqualValue(cq)));
        } else if (cq.matchChomp("^=")) {
            evaluator = new Evaluator.AttributeWithValueStarting(key, XTokenQueue.trimQuotes(this.chompEqualValue(cq)));
        } else if (cq.matchChomp("$=")) {
            evaluator = new Evaluator.AttributeWithValueEnding(key, XTokenQueue.trimQuotes(this.chompEqualValue(cq)));
        } else if (cq.matchChomp("*=")) {
            evaluator = new Evaluator.AttributeWithValueContaining(key, XTokenQueue.trimQuotes(this.chompEqualValue(cq)));
        } else if (cq.matchChomp("~=")) {
            evaluator = new Evaluator.AttributeWithValueMatching(key, Pattern.compile(XTokenQueue.trimQuotes(this.chompEqualValue(cq))));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", new Object[]{this.query, this.chompEqualValue(cq)});
        }
        return evaluator;
    }

    private String chompEqualValue(XTokenQueue cq) {
        String value = cq.matchChomp("'") ? cq.chompTo("'") : (cq.matchChomp("\"") ? cq.chompTo("\"") : (cq.containsAny(" ") ? cq.chompTo(" ") : cq.remainder()));
        return value;
    }

    public static XPathEvaluator parse(String xpathStr) {
        XPathParser xPathParser = new XPathParser(xpathStr);
        return xPathParser.parse();
    }

    static enum Operation {
        AND,
        OR;

    }

    static class EvaluatorStack
    extends Stack<Evaluator> {
        EvaluatorStack() {
        }

        public void calc(Evaluator evaluator, Operation operation) {
            if (this.size() == 0) {
                this.push(evaluator);
            } else {
                if (operation == Operation.AND) {
                    evaluator = new CombiningEvaluator.And((Evaluator)this.pop(), evaluator);
                } else {
                    this.mergeOr();
                }
                this.push(evaluator);
            }
        }

        public void mergeOr() {
            if (this.size() >= 2) {
                Evaluator pop1 = (Evaluator)this.pop();
                Evaluator pop2 = (Evaluator)this.pop();
                CombiningEvaluator.Or tempEvaluator = new CombiningEvaluator.Or(pop2, pop1);
                this.push(tempEvaluator);
            }
        }
    }
}

