/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic.configurable;

import us.codecraft.webmagic.configurable.ExpressionType;
import us.codecraft.webmagic.selector.JsonPathSelector;
import us.codecraft.webmagic.selector.Selector;
import us.codecraft.webmagic.selector.Selectors;

public class ExtractRule {
    private String fieldName;
    private ExpressionType expressionType;
    private String expressionValue;
    private String[] expressionParams;
    private boolean multi = false;
    private volatile Selector selector;
    private boolean notNull = false;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public ExpressionType getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(ExpressionType expressionType) {
        this.expressionType = expressionType;
    }

    public String getExpressionValue() {
        return this.expressionValue;
    }

    public void setExpressionValue(String expressionValue) {
        this.expressionValue = expressionValue;
    }

    public String[] getExpressionParams() {
        return this.expressionParams;
    }

    public void setExpressionParams(String[] expressionParams) {
        this.expressionParams = expressionParams;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector getSelector() {
        if (this.selector == null) {
            ExtractRule extractRule = this;
            synchronized (extractRule) {
                if (this.selector == null) {
                    this.selector = this.compileSelector();
                }
            }
        }
        return this.selector;
    }

    private Selector compileSelector() {
        switch (this.expressionType) {
            case Css: {
                if (this.expressionParams.length >= 1) {
                    return Selectors.$((String)this.expressionValue, (String)this.expressionParams[0]);
                }
                return Selectors.$((String)this.expressionValue);
            }
            case XPath: {
                return Selectors.xpath((String)this.expressionValue);
            }
            case Regex: {
                if (this.expressionParams.length >= 1) {
                    return Selectors.regex((String)this.expressionValue, (int)Integer.parseInt(this.expressionParams[0]));
                }
                return Selectors.regex((String)this.expressionValue);
            }
            case JsonPath: {
                return new JsonPathSelector(this.expressionValue);
            }
        }
        return Selectors.xpath((String)this.expressionValue);
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }
}

