/*
 * Decompiled with CFR 0.152.
 */
package us.codecraft.webmagic;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.Request;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.Task;
import us.codecraft.webmagic.downloader.Downloader;
import us.codecraft.webmagic.downloader.HttpClientDownloader;
import us.codecraft.webmagic.pipeline.CollectorPipeline;
import us.codecraft.webmagic.pipeline.ConsolePipeline;
import us.codecraft.webmagic.pipeline.Pipeline;
import us.codecraft.webmagic.pipeline.ResultItemsCollectorPipeline;
import us.codecraft.webmagic.processor.PageProcessor;
import us.codecraft.webmagic.scheduler.QueueScheduler;
import us.codecraft.webmagic.scheduler.Scheduler;
import us.codecraft.webmagic.utils.EnvironmentUtil;
import us.codecraft.webmagic.utils.ThreadUtils;
import us.codecraft.webmagic.utils.UrlUtils;

public class Spider
implements Runnable,
Task {
    protected Downloader downloader;
    protected List<Pipeline> pipelines = new ArrayList<Pipeline>();
    protected PageProcessor pageProcessor;
    protected List<Request> startRequests;
    protected Site site;
    protected String uuid;
    protected Scheduler scheduler = new QueueScheduler();
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executorService;
    protected int threadNum = 1;
    protected AtomicInteger stat = new AtomicInteger(0);
    protected boolean exitWhenComplete = true;
    protected static final int STAT_INIT = 0;
    protected static final int STAT_RUNNING = 1;
    protected static final int STAT_STOPPED = 2;
    protected boolean spawnUrl = true;
    protected boolean destroyWhenExit = true;
    private ReentrantLock newUrlLock = new ReentrantLock();
    private Condition newUrlCondition = this.newUrlLock.newCondition();
    private final AtomicInteger threadAlive = new AtomicInteger(0);
    private final AtomicLong pageCount = new AtomicLong(0L);

    public static Spider create(PageProcessor pageProcessor) {
        return new Spider(pageProcessor);
    }

    public Spider(PageProcessor pageProcessor) {
        this.pageProcessor = pageProcessor;
        this.site = pageProcessor.getSite();
        this.startRequests = pageProcessor.getSite().getStartRequests();
    }

    public Spider startUrls(List<String> startUrls) {
        this.checkIfRunning();
        this.startRequests = UrlUtils.convertToRequests(startUrls);
        return this;
    }

    public Spider startRequest(List<Request> startRequests) {
        this.checkIfRunning();
        this.startRequests = startRequests;
        return this;
    }

    public Spider setUUID(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public Spider scheduler(Scheduler scheduler) {
        return this.setScheduler(scheduler);
    }

    public Spider setScheduler(Scheduler scheduler) {
        this.checkIfRunning();
        this.scheduler = scheduler;
        return this;
    }

    public Spider pipeline(Pipeline pipeline) {
        return this.addPipeline(pipeline);
    }

    public Spider addPipeline(Pipeline pipeline) {
        this.checkIfRunning();
        this.pipelines.add(pipeline);
        return this;
    }

    public Spider setPipelines(List<Pipeline> pipelines) {
        this.checkIfRunning();
        this.pipelines = pipelines;
        return this;
    }

    public Spider clearPipeline() {
        this.pipelines = new ArrayList<Pipeline>();
        return this;
    }

    public Spider downloader(Downloader downloader) {
        return this.setDownloader(downloader);
    }

    public Spider setDownloader(Downloader downloader) {
        this.checkIfRunning();
        this.downloader = downloader;
        return this;
    }

    protected void initComponent() {
        if (this.downloader == null) {
            this.downloader = new HttpClientDownloader();
        }
        if (this.pipelines.isEmpty()) {
            this.pipelines.add(new ConsolePipeline());
        }
        this.downloader.setThread(this.threadNum);
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = ThreadUtils.newFixedThreadPool(this.threadNum);
        }
        if (this.startRequests != null) {
            for (Request request : this.startRequests) {
                this.scheduler.push(request, this);
            }
            this.startRequests.clear();
        }
        this.threadAlive.set(0);
    }

    @Override
    public void run() {
        this.checkRunningStat();
        this.initComponent();
        this.logger.info("Spider " + this.getUUID() + " started!");
        while (!Thread.currentThread().isInterrupted() && this.stat.get() == 1) {
            Request request = this.scheduler.poll(this);
            if (request == null) {
                if (this.threadAlive.get() == 0 && this.exitWhenComplete) break;
                this.waitNewUrl();
                continue;
            }
            final Request requestFinal = request;
            this.threadAlive.incrementAndGet();
            this.executorService.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Spider.this.processRequest(requestFinal);
                    }
                    catch (Exception e) {
                        Spider.this.logger.error("download " + requestFinal + " error", (Throwable)e);
                    }
                    finally {
                        Spider.this.threadAlive.decrementAndGet();
                        Spider.this.pageCount.incrementAndGet();
                        Spider.this.signalNewUrl();
                    }
                }
            });
        }
        this.stat.set(2);
        if (this.destroyWhenExit) {
            this.close();
        }
    }

    private void checkRunningStat() {
        int statNow;
        do {
            if ((statNow = this.stat.get()) != 1) continue;
            throw new IllegalStateException("Spider is already running!");
        } while (!this.stat.compareAndSet(statNow, 1));
    }

    public void close() {
        this.destroyEach(this.downloader);
        this.destroyEach(this.pageProcessor);
        for (Pipeline pipeline : this.pipelines) {
            this.destroyEach(pipeline);
        }
        this.executorService.shutdown();
    }

    private void destroyEach(Object object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void test(String ... urls) {
        this.initComponent();
        if (urls.length > 0) {
            for (String url : urls) {
                this.processRequest(new Request(url));
            }
        }
    }

    protected void processRequest(Request request) {
        Page page = this.downloader.download(request, this);
        if (page == null) {
            this.sleep(this.site.getSleepTime());
            return;
        }
        if (page.isNeedCycleRetry()) {
            this.extractAndAddRequests(page, true);
            this.sleep(this.site.getSleepTime());
            return;
        }
        this.pageProcessor.process(page);
        this.extractAndAddRequests(page, this.spawnUrl);
        if (!page.getResultItems().isSkip()) {
            for (Pipeline pipeline : this.pipelines) {
                pipeline.process(page.getResultItems(), this);
            }
        }
        this.sleep(this.site.getSleepTime());
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void extractAndAddRequests(Page page, boolean spawnUrl) {
        if (spawnUrl && CollectionUtils.isNotEmpty(page.getTargetRequests())) {
            for (Request request : page.getTargetRequests()) {
                this.addRequest(request);
            }
        }
    }

    private void addRequest(Request request) {
        if (this.site.getDomain() == null && request != null && request.getUrl() != null) {
            this.site.setDomain(UrlUtils.getDomain(request.getUrl()));
        }
        this.scheduler.push(request, this);
    }

    protected void checkIfRunning() {
        if (this.stat.get() == 1) {
            throw new IllegalStateException("Spider is already running!");
        }
    }

    public void runAsync() {
        Thread thread = new Thread(this);
        thread.setDaemon(false);
        thread.start();
    }

    public Spider addUrl(String ... urls) {
        for (String url : urls) {
            this.addRequest(new Request(url));
        }
        this.signalNewUrl();
        return this;
    }

    public <T> List<T> getAll(Collection<String> urls) {
        this.destroyWhenExit = false;
        this.spawnUrl = false;
        this.startRequests.clear();
        for (Request request : UrlUtils.convertToRequests(urls)) {
            this.addRequest(request);
        }
        CollectorPipeline collectorPipeline = this.getCollectorPipeline();
        this.pipelines.add(collectorPipeline);
        this.run();
        this.spawnUrl = true;
        this.destroyWhenExit = true;
        return collectorPipeline.getCollected();
    }

    protected CollectorPipeline getCollectorPipeline() {
        return new ResultItemsCollectorPipeline();
    }

    public <T> T get(String url) {
        ArrayList urls = Lists.newArrayList((Object[])new String[]{url});
        List<T> resultItemses = this.getAll(urls);
        if (resultItemses != null && resultItemses.size() > 0) {
            return resultItemses.get(0);
        }
        return null;
    }

    public Spider addRequest(Request ... requests) {
        for (Request request : requests) {
            this.addRequest(request);
        }
        this.signalNewUrl();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitNewUrl() {
        try {
            this.newUrlLock.lock();
            if (this.threadAlive.get() == 0 && this.exitWhenComplete) {
                return;
            }
            try {
                this.newUrlCondition.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            this.newUrlLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNewUrl() {
        try {
            this.newUrlLock.lock();
            this.newUrlCondition.signalAll();
        }
        finally {
            this.newUrlLock.unlock();
        }
    }

    public void start() {
        this.runAsync();
    }

    public void stop() {
        if (this.stat.compareAndSet(1, 2)) {
            this.logger.info("Spider " + this.getUUID() + " stop success!");
        } else {
            this.logger.info("Spider " + this.getUUID() + " stop fail!");
        }
    }

    public Spider thread(int threadNum) {
        this.checkIfRunning();
        this.threadNum = threadNum;
        if (threadNum <= 0) {
            throw new IllegalArgumentException("threadNum should be more than one!");
        }
        return this;
    }

    public static void xsoupOff() {
        EnvironmentUtil.setUseXsoup(false);
    }

    public boolean isExitWhenComplete() {
        return this.exitWhenComplete;
    }

    public Spider setExitWhenComplete(boolean exitWhenComplete) {
        this.exitWhenComplete = exitWhenComplete;
        return this;
    }

    public boolean isSpawnUrl() {
        return this.spawnUrl;
    }

    public long getPageCount() {
        return this.pageCount.get();
    }

    public Status getStatus() {
        return Status.fromValue(this.stat.get());
    }

    public int getThreadAlive() {
        return this.threadAlive.get();
    }

    public Spider setSpawnUrl(boolean spawnUrl) {
        this.spawnUrl = spawnUrl;
        return this;
    }

    @Override
    public String getUUID() {
        if (this.uuid != null) {
            return this.uuid;
        }
        if (this.site != null) {
            return this.site.getDomain();
        }
        this.uuid = UUID.randomUUID().toString();
        return this.uuid;
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    public static enum Status {
        Init(0),
        Running(1),
        Stopped(2);

        private int value;

        private Status(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        public static Status fromValue(int value) {
            for (Status status : Status.values()) {
                if (status.getValue() != value) continue;
                return status;
            }
            return Init;
        }
    }
}

