/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import uk.gov.gchq.gaffer.commonutil.ToStringBuilder;

public class OneOrMore<T>
implements Iterable<T> {
    private final Function<T, Collection<T>> newCollection;
    private final boolean deduplicate;
    private Collection<T> collection;
    private T singleItem;

    public OneOrMore() {
        this(true);
    }

    public OneOrMore(boolean deduplicate) {
        this(deduplicate, null);
    }

    public OneOrMore(boolean deduplicate, T item) {
        this.deduplicate = deduplicate;
        this.singleItem = item;
        this.newCollection = deduplicate ? k -> {
            HashSet<Object> collection = new HashSet<Object>();
            collection.add(k);
            return collection;
        } : k -> {
            ArrayList<Object> collection = new ArrayList<Object>();
            collection.add(k);
            return collection;
        };
    }

    public boolean add(T item) {
        if (null == this.collection) {
            if (null == this.singleItem) {
                this.singleItem = item;
                return true;
            }
            this.collection = this.newCollection.apply(this.singleItem);
            this.singleItem = null;
        }
        return this.collection.add(item);
    }

    public boolean addAll(Collection<? extends T> items) {
        boolean result = false;
        for (T item : items) {
            if (!this.add(item)) continue;
            result = true;
        }
        return result;
    }

    public void removeAnyItem() {
        if (null == this.collection) {
            this.singleItem = null;
        } else if (this.deduplicate) {
            this.collection.remove(this.collection.iterator().next());
        } else {
            ((List)this.collection).remove(this.collection.size() - 1);
        }
    }

    public int size() {
        if (null == this.collection) {
            if (null != this.singleItem) {
                return 1;
            }
            return 0;
        }
        return this.collection.size();
    }

    public boolean isEmpty() {
        if (null == this.collection) {
            return null == this.singleItem;
        }
        return this.collection.isEmpty();
    }

    public boolean contains(Object o) {
        if (null == this.collection) {
            return null != this.singleItem && this.singleItem.equals(o);
        }
        return this.collection.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        if (null == this.collection) {
            if (null == this.singleItem) {
                return Iterators.emptyIterator();
            }
            return Iterators.singletonIterator(this.singleItem);
        }
        return this.collection.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        OneOrMore that = (OneOrMore)obj;
        return new EqualsBuilder().append(this.deduplicate, that.deduplicate).append(this.singleItem, that.singleItem).append(this.collection, that.collection).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 31).append(this.deduplicate).append(this.singleItem).append(this.collection).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("deduplicate", this.deduplicate).append("singleItem", this.singleItem).append("collection", this.collection).toString();
    }
}

