/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private JsonUtil() {
    }

    public static boolean equals(String expectedJson, String actualJson) {
        try {
            Map expectedSchemaMap = null != expectedJson ? (Map)OBJECT_MAPPER.readValue(expectedJson, Map.class) : Collections.emptyMap();
            Map actualSchemaMap = null != actualJson ? (Map)OBJECT_MAPPER.readValue(actualJson, Map.class) : Collections.emptyMap();
            return Objects.equals(expectedSchemaMap, actualSchemaMap);
        }
        catch (IOException expectedSchemaMap) {
            try {
                List expectedSchemaMap2 = null != expectedJson ? (List)OBJECT_MAPPER.readValue(expectedJson, List.class) : Collections.emptyList();
                List actualSchemaMap = null != actualJson ? (List)OBJECT_MAPPER.readValue(actualJson, List.class) : Collections.emptyList();
                return Objects.equals(expectedSchemaMap2, actualSchemaMap);
            }
            catch (IOException e) {
                JsonUtil.logError(expectedJson, actualJson, e);
                return false;
            }
        }
    }

    public static boolean equals(byte[] expectedJson, byte[] actualJson) {
        try {
            Map expectedSchemaMap = null != expectedJson ? (Map)OBJECT_MAPPER.readValue(expectedJson, Map.class) : Collections.emptyMap();
            Map actualSchemaMap = null != actualJson ? (Map)OBJECT_MAPPER.readValue(actualJson, Map.class) : Collections.emptyMap();
            return Objects.equals(expectedSchemaMap, actualSchemaMap);
        }
        catch (IOException e) {
            JsonUtil.logError(expectedJson, actualJson, e);
            try {
                List expectedSchemaMap = null != expectedJson ? (List)OBJECT_MAPPER.readValue(expectedJson, List.class) : Collections.emptyList();
                List actualSchemaMap = null != actualJson ? (List)OBJECT_MAPPER.readValue(actualJson, List.class) : Collections.emptyList();
                return Objects.equals(expectedSchemaMap, actualSchemaMap);
            }
            catch (IOException e2) {
                JsonUtil.logError(expectedJson, actualJson, e2);
                return false;
            }
        }
    }

    private static void logError(Object expectedJson, Object actualJson, IOException e) {
        LOGGER.debug("Error comparing json.\nexpectedJson:\n {}\n actual json:\n", new Object[]{expectedJson, actualJson, e});
    }
}

