/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.gchq.gaffer.commonutil;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;

public final class CommonTimeUtil {
    private CommonTimeUtil() {
    }

    public static long timeToBucket(long time, TimeBucket bucket) {
        long timeBucket;
        OffsetDateTime dateTime = Instant.ofEpochMilli(time).atOffset(ZoneOffset.UTC);
        switch (bucket) {
            case SECOND: {
                timeBucket = dateTime.truncatedTo(ChronoUnit.SECONDS).toInstant().toEpochMilli();
                break;
            }
            case MINUTE: {
                timeBucket = dateTime.truncatedTo(ChronoUnit.MINUTES).toInstant().toEpochMilli();
                break;
            }
            case HOUR: {
                timeBucket = dateTime.truncatedTo(ChronoUnit.HOURS).toInstant().toEpochMilli();
                break;
            }
            case DAY: {
                timeBucket = dateTime.truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli();
                break;
            }
            case WEEK: {
                timeBucket = dateTime.with(CommonTimeUtil.firstDayOfWeek()).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli();
                break;
            }
            case MONTH: {
                timeBucket = dateTime.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli();
                break;
            }
            default: {
                timeBucket = time;
            }
        }
        return timeBucket;
    }

    private static TemporalAdjuster firstDayOfWeek() {
        return t -> t.with(ChronoField.DAY_OF_WEEK, 1L);
    }

    public static enum TimeBucket {
        SECOND,
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        YEAR;

    }
}

