/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.support.RequestContext;
import org.springframework.web.servlet.tags.HtmlEscapeTag;
import org.springframework.web.util.ExpressionEvaluationUtils;

public abstract class RequestContextAwareTag
extends TagSupport
implements TryCatchFinally {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String htmlEscape;
    private RequestContext requestContext;

    public void setHtmlEscape(String htmlEscape) {
        this.htmlEscape = htmlEscape;
    }

    protected boolean isHtmlEscape() throws JspException {
        if (this.htmlEscape != null) {
            return ExpressionEvaluationUtils.evaluateBoolean("htmlEscape", this.htmlEscape, this.pageContext);
        }
        return HtmlEscapeTag.isDefaultHtmlEscape(this.pageContext);
    }

    public final int doStartTag() throws JspException {
        try {
            this.requestContext = new RequestContext((HttpServletRequest)this.pageContext.getRequest());
            return this.doStartTagInternal();
        }
        catch (JspException ex) {
            this.logger.error((Object)"Exception in RequestContextAwareTag", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)"Exception in RequestContextAwareTag", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception in RequestContextAwareTag", (Throwable)ex);
            throw new JspTagException(ex.getMessage());
        }
    }

    protected final RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected abstract int doStartTagInternal() throws Exception;

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.requestContext = null;
    }
}

