/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.validation.BindException;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.AbstractController;

public abstract class BaseCommandController
extends AbstractController {
    public static final String DEFAULT_COMMAND_NAME = "command";
    private String commandName = "command";
    private Class commandClass;
    private Validator[] validators;
    private boolean validateOnBinding = true;
    private MessageCodesResolver messageCodesResolver;

    public final void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    protected final String getCommandName() {
        return this.commandName;
    }

    public final void setCommandClass(Class commandClass) {
        this.commandClass = commandClass;
    }

    protected final Class getCommandClass() {
        return this.commandClass;
    }

    public final void setValidators(Validator[] validators) {
        this.validators = validators;
    }

    protected final Validator[] getValidators() {
        return this.validators;
    }

    public final void setValidator(Validator validator) {
        this.validators = new Validator[]{validator};
    }

    protected final Validator getValidator() {
        return this.validators != null && this.validators.length > 0 ? this.validators[0] : null;
    }

    public final void setValidateOnBinding(boolean validateOnBinding) {
        this.validateOnBinding = validateOnBinding;
    }

    protected final boolean isValidateOnBinding() {
        return this.validateOnBinding;
    }

    public final void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    protected final MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    protected void initApplicationContext() {
        if (this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                if (this.commandClass == null || this.validators[i].supports(this.commandClass)) continue;
                throw new IllegalArgumentException("Validator [" + this.validators[i] + "] does not support command class [" + this.commandClass.getName() + "]");
            }
        }
    }

    protected Object getCommand(HttpServletRequest request) throws Exception {
        return this.createCommand();
    }

    protected final Object createCommand() throws InstantiationException, IllegalAccessException {
        if (this.commandClass == null) {
            throw new IllegalStateException("Cannot create command without commandClass being set - either set commandClass or override formBackingObject");
        }
        this.logger.debug((Object)("Creating new command of class [" + this.commandClass.getName() + "]"));
        return this.commandClass.newInstance();
    }

    protected final boolean checkCommand(Object command) {
        return this.commandClass == null || this.commandClass.isInstance(command);
    }

    protected final ServletRequestDataBinder bindAndValidate(HttpServletRequest request, Object command) throws Exception {
        ServletRequestDataBinder binder = this.createBinder(request, command);
        binder.bind((ServletRequest)request);
        this.onBind(request, command, binder.getErrors());
        if (this.isValidateOnBinding() && this.validators != null) {
            for (int i = 0; i < this.validators.length; ++i) {
                ValidationUtils.invokeValidator(this.validators[i], command, binder.getErrors());
            }
        }
        this.onBindAndValidate(request, command, binder.getErrors());
        return binder;
    }

    protected ServletRequestDataBinder createBinder(HttpServletRequest request, Object command) throws Exception {
        ServletRequestDataBinder binder = new ServletRequestDataBinder(command, this.getCommandName());
        if (this.messageCodesResolver != null) {
            binder.setMessageCodesResolver(this.messageCodesResolver);
        }
        this.initBinder(request, binder);
        return binder;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
    }

    protected void onBind(HttpServletRequest request, Object command, BindException errors) throws Exception {
        this.onBind(request, command);
    }

    protected void onBind(HttpServletRequest request, Object command) throws Exception {
    }

    protected void onBindAndValidate(HttpServletRequest request, Object command, BindException errors) throws Exception {
    }
}

