/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ServletRequestDataBinder
extends DataBinder {
    private boolean bindEmptyMultipartFiles = true;

    public ServletRequestDataBinder(Object target, String name) {
        super(target, name);
    }

    public void setBindEmptyMultipartFiles(boolean bindEmptyMultipartFiles) {
        this.bindEmptyMultipartFiles = bindEmptyMultipartFiles;
    }

    public void bind(ServletRequest request) {
        ServletRequestParameterPropertyValues pvs = new ServletRequestParameterPropertyValues(request);
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            Iterator it = fileMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                MultipartFile value = (MultipartFile)fileMap.get(key);
                if (!this.bindEmptyMultipartFiles && value.isEmpty()) continue;
                pvs.addPropertyValue(key, value);
            }
        }
        this.bind(pvs);
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getErrors().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getErrors().getObjectName() + "'", this.getErrors());
        }
    }
}

