/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
implements MethodInterceptor,
InitializingBean {
    private static ThreadLocal currentTransactionStatus = new ThreadLocal();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;

    public static TransactionStatus currentTransactionStatus() throws AspectException {
        TransactionStatus status = (TransactionStatus)currentTransactionStatus.get();
        if (status == null) {
            throw new NoTransactionException("No TransactionInterceptor-managed TransactionStatus in scope");
        }
        return status;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionAttributes(Properties transactionAttributes) {
        NameMatchTransactionAttributeSource tas = new NameMatchTransactionAttributeSource();
        tas.setProperties(transactionAttributes);
        this.transactionAttributeSource = tas;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        this.transactionAttributeSource = transactionAttributeSource;
    }

    public TransactionAttributeSource getTransactionAttributeSource() {
        return this.transactionAttributeSource;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("transactionManager is required");
        }
        if (this.transactionAttributeSource == null) {
            throw new IllegalArgumentException("Either 'transactionAttributeSource' or 'transactionAttributes' is required: If there are no transactional methods, don't use a TransactionInterceptor respectively a transactional proxy.");
        }
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        TransactionAttribute transAtt = this.transactionAttributeSource.getTransactionAttribute(invocation.getMethod(), targetClass);
        TransactionStatus status = null;
        TransactionStatus oldTransactionStatus = null;
        if (transAtt != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting transaction for method '" + invocation.getMethod().getName() + "' in class [" + invocation.getMethod().getDeclaringClass().getName() + "]"));
            }
            status = this.transactionManager.getTransaction(transAtt);
            oldTransactionStatus = (TransactionStatus)currentTransactionStatus.get();
            currentTransactionStatus.set(status);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Don't need to create transaction for method '" + invocation.getMethod().getName() + "' in class [" + invocation.getMethod().getDeclaringClass().getName() + "]: this method isn't transactional"));
        }
        Object retVal = null;
        try {
            try {
                retVal = invocation.proceed();
            }
            catch (Throwable ex) {
                if (status != null) {
                    this.onThrowable(invocation, transAtt, status, ex);
                }
                throw ex;
            }
            Object var9_7 = null;
            if (transAtt != null) {
                currentTransactionStatus.set(oldTransactionStatus);
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (transAtt != null) {
                currentTransactionStatus.set(oldTransactionStatus);
            }
            throw throwable;
        }
        if (status != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking commit for transaction on method '" + invocation.getMethod().getName() + "' in class [" + invocation.getMethod().getDeclaringClass().getName() + "]"));
            }
            this.transactionManager.commit(status);
        }
        return retVal;
    }

    private void onThrowable(MethodInvocation invocation, TransactionAttribute txAtt, TransactionStatus status, Throwable ex) {
        if (txAtt.rollbackOn(ex)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Invoking rollback for transaction on method '" + invocation.getMethod().getName() + "' in class [" + invocation.getMethod().getDeclaringClass().getName() + "] due to throwable [" + ex + "]"));
            }
            try {
                this.transactionManager.rollback(status);
            }
            catch (TransactionException tex) {
                this.logger.error((Object)"Application exception overridden by rollback exception", ex);
                throw tex;
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method '" + invocation.getMethod().getName() + "' in class [" + invocation.getMethod().getDeclaringClass().getName() + "] threw throwable [" + ex + "] but this does not force transaction rollback"));
            }
            this.transactionManager.commit(status);
        }
    }
}

