/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class WebLogicNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_EXTENSION_NAME = "weblogic.jdbc.extensions.WLConnection";
    private final Class jdbcExtensionClass = this.getClass().getClassLoader().loadClass("weblogic.jdbc.extensions.WLConnection");
    private final Method getVendorConnectionMethod = this.jdbcExtensionClass.getMethod("getVendorConnection", new Class[0]);

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    public Connection getNativeConnection(Connection con) throws SQLException {
        if (this.jdbcExtensionClass.isAssignableFrom(con.getClass())) {
            try {
                return (Connection)this.getVendorConnectionMethod.invoke((Object)con, new Object[0]);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not invoke WebLogic's getVendorConnection method", ex);
            }
        }
        return con;
    }
}

