/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class ReloadableResourceBundleMessageSource
extends AbstractMessageSource
implements ResourceLoaderAware {
    public static final String PROPERTIES_SUFFIX = ".properties";
    private String[] basenames;
    private String defaultEncoding;
    private Properties fileEncodings;
    private boolean fallbackToSystemLocale = true;
    private long cacheMillis = -1L;
    private final Map cachedFilenames = new HashMap();
    private final Map cachedProperties = new HashMap();
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setFileEncodings(Properties fileEncodings) {
        this.fileEncodings = fileEncodings;
    }

    public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
        this.fallbackToSystemLocale = fallbackToSystemLocale;
    }

    public void setCacheSeconds(int cacheSeconds) {
        this.cacheMillis = cacheSeconds * 1000;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        for (int i = 0; i < this.basenames.length; ++i) {
            List filenames = this.calculateAllFilenames(this.basenames[i], locale);
            for (int j = 0; j < filenames.size(); ++j) {
                MessageFormat result;
                String filename = (String)filenames.get(j);
                PropertiesHolder propHolder = this.getProperties(filename);
                if (propHolder.getProperties() == null || (result = propHolder.getMessageFormat(code, locale)) == null) continue;
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List calculateAllFilenames(String basename, Locale locale) {
        Map map = this.cachedFilenames;
        synchronized (map) {
            ArrayList<String> filenames;
            HashMap localeMap = (HashMap)this.cachedFilenames.get(basename);
            if (localeMap != null && (filenames = (ArrayList<String>)localeMap.get(locale)) != null) {
                return filenames;
            }
            filenames = new ArrayList<String>(7);
            filenames.addAll(this.calculateFilenamesForLocale(basename, locale));
            if (this.fallbackToSystemLocale && !locale.equals(Locale.getDefault())) {
                filenames.addAll(this.calculateFilenamesForLocale(basename, Locale.getDefault()));
            }
            filenames.add(basename);
            if (localeMap != null) {
                localeMap.put(locale, filenames);
            } else {
                localeMap = new HashMap();
                localeMap.put(locale, filenames);
                this.cachedFilenames.put(basename, localeMap);
            }
            return filenames;
        }
    }

    protected List calculateFilenamesForLocale(String basename, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer temp = new StringBuffer(basename);
        if (language.length() > 0) {
            temp.append('_').append(language);
            result.add(0, temp.toString());
        }
        if (country.length() > 0) {
            temp.append('_').append(country);
            result.add(0, temp.toString());
        }
        if (variant.length() > 0) {
            temp.append('_').append(variant);
            result.add(0, temp.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder getProperties(String filename) {
        Map map = this.cachedProperties;
        synchronized (map) {
            PropertiesHolder propHolder = (PropertiesHolder)this.cachedProperties.get(filename);
            if (propHolder != null && (propHolder.getRefreshTimestamp() < 0L || propHolder.getRefreshTimestamp() > System.currentTimeMillis() - this.cacheMillis)) {
                return propHolder;
            }
            return this.refreshProperties(filename, propHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesHolder refreshProperties(String filename, PropertiesHolder propHolder) {
        long refreshTimestamp = this.cacheMillis < 0L ? -1L : System.currentTimeMillis();
        Resource resource = this.resourceLoader.getResource(filename + PROPERTIES_SUFFIX);
        try {
            long fileTimestamp = -1L;
            if (this.cacheMillis >= 0L) {
                fileTimestamp = resource.getFile().lastModified();
                if (fileTimestamp == 0L) {
                    throw new IOException("File [" + resource.getFile().getAbsolutePath() + "] does not exist");
                }
                if (propHolder != null && propHolder.getFileTimestamp() == fileTimestamp) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Re-caching properties for filename [" + filename + "] - file hasn't been modified"));
                    }
                    propHolder.setRefreshTimestamp(refreshTimestamp);
                    return propHolder;
                }
            }
            InputStream is = resource.getInputStream();
            Properties props = new Properties();
            try {
                String charset = null;
                if (this.fileEncodings != null) {
                    charset = this.fileEncodings.getProperty(filename);
                }
                if (charset == null) {
                    charset = this.defaultEncoding;
                }
                if (charset != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties for filename [" + filename + "] with charset '" + charset + "'"));
                    }
                    this.propertiesPersister.load(props, new InputStreamReader(is, charset));
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Loading properties for filename [" + filename + "]"));
                    }
                    this.propertiesPersister.load(props, is);
                }
                propHolder = new PropertiesHolder(props, fileTimestamp);
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Properties file [" + filename + "] not found for MessageSource: " + ex.getMessage()));
            }
            propHolder = new PropertiesHolder();
        }
        propHolder.setRefreshTimestamp(refreshTimestamp);
        this.cachedProperties.put(filename, propHolder);
        return propHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.info((Object)"Clearing resource bundle cache");
        Map map = this.cachedProperties;
        synchronized (map) {
            this.cachedProperties.clear();
        }
    }

    public void clearCacheIncludingAncestors() {
        this.clearCache();
        if (this.getParentMessageSource() instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)this.getParentMessageSource()).clearCacheIncludingAncestors();
        }
    }

    public String toString() {
        return this.getClass().getName() + ": basenames=[" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }

    protected class PropertiesHolder {
        private Properties properties;
        private long fileTimestamp = -1L;
        private long refreshTimestamp = -1L;
        private final Map cachedMessageFormats = new HashMap();

        protected PropertiesHolder(Properties properties, long fileTimestamp) {
            this.properties = properties;
            this.fileTimestamp = fileTimestamp;
        }

        protected PropertiesHolder() {
        }

        protected Properties getProperties() {
            return this.properties;
        }

        protected long getFileTimestamp() {
            return this.fileTimestamp;
        }

        protected void setRefreshTimestamp(long refreshTimestamp) {
            this.refreshTimestamp = refreshTimestamp;
        }

        protected long getRefreshTimestamp() {
            return this.refreshTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected MessageFormat getMessageFormat(String code, Locale locale) {
            Map map = this.cachedMessageFormats;
            synchronized (map) {
                MessageFormat result;
                HashMap<Locale, MessageFormat> localeMap = (HashMap<Locale, MessageFormat>)this.cachedMessageFormats.get(code);
                if (localeMap != null && (result = (MessageFormat)localeMap.get(locale)) != null) {
                    return result;
                }
                String msg = this.properties.getProperty(code);
                if (msg != null) {
                    if (localeMap == null) {
                        localeMap = new HashMap<Locale, MessageFormat>();
                        this.cachedMessageFormats.put(code, localeMap);
                    }
                    MessageFormat result2 = ReloadableResourceBundleMessageSource.this.createMessageFormat(msg, locale);
                    localeMap.put(locale, result2);
                    return result2;
                }
                return null;
            }
        }
    }
}

