/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;

public class PropertiesFactoryBean
extends AbstractFactoryBean {
    private Properties properties;
    private Resource[] locations;
    private String fileEncoding;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();
    static /* synthetic */ Class class$java$util$Properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setFileEncoding(String encoding) {
        this.fileEncoding = encoding;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister;
    }

    public Class getObjectType() {
        return class$java$util$Properties == null ? (class$java$util$Properties = PropertiesFactoryBean.class$("java.util.Properties")) : class$java$util$Properties;
    }

    protected Object createInstance() throws Exception {
        return this.mergeProperties();
    }

    protected Properties mergeProperties() throws IOException {
        if (this.properties == null && this.locations == null) {
            throw new IllegalArgumentException("Either properties or location(s) must be set");
        }
        Properties result = new Properties();
        if (this.properties != null) {
            result.putAll((Map<?, ?>)this.properties);
        }
        if (this.locations != null) {
            result.putAll((Map<?, ?>)this.loadProperties());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties() throws IOException {
        Properties props = new Properties();
        for (int i = 0; i < this.locations.length; ++i) {
            Resource location = this.locations[i];
            this.logger.info((Object)("Loading properties file from " + location));
            InputStream is = location.getInputStream();
            try {
                if (this.fileEncoding != null) {
                    this.propertiesPersister.load(props, new InputStreamReader(is, this.fileEncoding));
                    continue;
                }
                this.propertiesPersister.load(props, is);
                continue;
            }
            finally {
                is.close();
            }
        }
        return props;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

