/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.util.StringUtils;

public class MutablePropertyValues
implements PropertyValues,
Serializable {
    private final List propertyValuesList = new ArrayList();

    public MutablePropertyValues() {
    }

    public MutablePropertyValues(PropertyValues source) {
        this.addPropertyValues(source);
    }

    public MutablePropertyValues(Map source) {
        this.addPropertyValues(source);
    }

    public void addPropertyValues(PropertyValues source) {
        if (source != null) {
            PropertyValue[] pvs = source.getPropertyValues();
            for (int i = 0; i < pvs.length; ++i) {
                this.addPropertyValue(new PropertyValue(pvs[i].getName(), pvs[i].getValue()));
            }
        }
    }

    public void addPropertyValues(Map source) {
        if (source != null) {
            Iterator it = source.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.addPropertyValue(new PropertyValue(key, source.get(key)));
            }
        }
    }

    public void addPropertyValue(PropertyValue pv) {
        for (int i = 0; i < this.propertyValuesList.size(); ++i) {
            PropertyValue currentPv = (PropertyValue)this.propertyValuesList.get(i);
            if (!currentPv.getName().equals(pv.getName())) continue;
            this.propertyValuesList.set(i, pv);
            return;
        }
        this.propertyValuesList.add(pv);
    }

    public void addPropertyValue(String propertyName, Object propertyValue) {
        this.addPropertyValue(new PropertyValue(propertyName, propertyValue));
    }

    public void removePropertyValue(PropertyValue pv) {
        this.propertyValuesList.remove(pv);
    }

    public void removePropertyValue(String propertyName) {
        this.removePropertyValue(this.getPropertyValue(propertyName));
    }

    public void setPropertyValueAt(PropertyValue pv, int i) {
        this.propertyValuesList.set(i, pv);
    }

    public PropertyValue[] getPropertyValues() {
        return this.propertyValuesList.toArray(new PropertyValue[0]);
    }

    public PropertyValue getPropertyValue(String propertyName) {
        for (int i = 0; i < this.propertyValuesList.size(); ++i) {
            PropertyValue pv = (PropertyValue)this.propertyValuesList.get(i);
            if (!pv.getName().equals(propertyName)) continue;
            return pv;
        }
        return null;
    }

    public boolean contains(String propertyName) {
        return this.getPropertyValue(propertyName) != null;
    }

    public PropertyValues changesSince(PropertyValues old) {
        MutablePropertyValues changes = new MutablePropertyValues();
        if (old == this) {
            return changes;
        }
        for (int i = 0; i < this.propertyValuesList.size(); ++i) {
            PropertyValue newPv = (PropertyValue)this.propertyValuesList.get(i);
            PropertyValue pvOld = old.getPropertyValue(newPv.getName());
            if (pvOld == null) {
                changes.addPropertyValue(newPv);
                continue;
            }
            if (pvOld.equals(newPv)) continue;
            changes.addPropertyValue(newPv);
        }
        return changes;
    }

    public String toString() {
        Object[] pvs = this.getPropertyValues();
        StringBuffer sb = new StringBuffer("MutablePropertyValues: length=" + pvs.length + "; ");
        sb.append(StringUtils.arrayToDelimitedString(pvs, ","));
        return sb.toString();
    }
}

