/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.lang.reflect.Method;
import org.springframework.aop.MethodMatcher;

public abstract class MethodMatchers {
    public static MethodMatcher union(MethodMatcher a, MethodMatcher b) {
        return new UnionMethodMatcher(a, b);
    }

    public static MethodMatcher intersection(MethodMatcher a, MethodMatcher b) {
        return new IntersectionMethodMatcher(a, b);
    }

    private static class IntersectionMethodMatcher
    implements MethodMatcher {
        private MethodMatcher a;
        private MethodMatcher b;

        private IntersectionMethodMatcher(MethodMatcher a, MethodMatcher b) {
            this.a = a;
            this.b = b;
        }

        public boolean matches(Method m, Class targetClass) {
            return this.a.matches(m, targetClass) && this.b.matches(m, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method m, Class targetClass, Object[] args) {
            boolean aMatches = this.a.isRuntime() ? this.a.matches(m, targetClass, args) : this.a.matches(m, targetClass);
            boolean bMatches = this.b.isRuntime() ? this.b.matches(m, targetClass, args) : this.b.matches(m, targetClass);
            return aMatches && bMatches;
        }
    }

    private static class UnionMethodMatcher
    implements MethodMatcher {
        private MethodMatcher a;
        private MethodMatcher b;

        private UnionMethodMatcher(MethodMatcher a, MethodMatcher b) {
            this.a = a;
            this.b = b;
        }

        public boolean matches(Method m, Class targetClass) {
            return this.a.matches(m, targetClass) || this.b.matches(m, targetClass);
        }

        public boolean isRuntime() {
            return this.a.isRuntime() || this.b.isRuntime();
        }

        public boolean matches(Method m, Class targetClass, Object[] args) {
            return this.a.matches(m, targetClass, args) || this.b.matches(m, targetClass, args);
        }
    }
}

