/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class Utils {
    static final byte[] EMPTY_ARRAY = new byte[0];
    private static final ByteBuffer ZERO_BYTE_BUF = ByteBuffer.allocate(8192).asReadOnlyBuffer();

    private Utils() {
    }

    static native long getNativeBufferOffset(ByteBuffer var0, ByteBuffer var1);

    static boolean buffersMaybeOverlap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        long l;
        boolean bl = byteBuffer.isDirect();
        boolean bl2 = byteBuffer2.isDirect();
        boolean bl3 = byteBuffer.hasArray();
        boolean bl4 = byteBuffer2.hasArray();
        if ((bl || bl2) && bl != bl2) {
            return false;
        }
        if (bl && bl2) {
            return Utils.getNativeBufferOffset(byteBuffer.slice(), byteBuffer2.slice()) <= Integer.MAX_VALUE;
        }
        if (!bl3 || !bl4) {
            return true;
        }
        if (byteBuffer.array() != byteBuffer2.array()) {
            return false;
        }
        long l2 = (long)byteBuffer.arrayOffset() + (long)byteBuffer.position();
        if (l2 > (l = (long)byteBuffer2.arrayOffset() + (long)byteBuffer2.position())) {
            return l + (long)byteBuffer2.limit() > l2;
        }
        return l2 + (long)byteBuffer.limit() > l;
    }

    static boolean arraysOverlap(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray != byArray2) {
            return false;
        }
        if (n > n2) {
            return Utils.arraysOverlap(byArray2, n2, byArray, n, n3);
        }
        return (long)n + (long)n3 > (long)n2;
    }

    static byte[] encodeForWrapping(Key key) throws InvalidKeyException {
        try {
            byte[] byArray;
            if (key instanceof SecretKey) {
                byArray = key.getEncoded();
            } else if (key instanceof PublicKey) {
                KeyFactory keyFactory = KeyFactory.getInstance(key.getAlgorithm());
                byArray = keyFactory.getKeySpec(key, X509EncodedKeySpec.class).getEncoded();
            } else if (key instanceof PrivateKey) {
                KeyFactory keyFactory = KeyFactory.getInstance(key.getAlgorithm());
                byArray = keyFactory.getKeySpec(key, PKCS8EncodedKeySpec.class).getEncoded();
            } else {
                throw new InvalidKeyException("Key does not implement SecretKey, PublicKey, or PrivateKey");
            }
            if (byArray == null || byArray.length == 0) {
                throw new InvalidKeyException("Could not obtain encoded key");
            }
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new InvalidKeyException("Wrapping failed", generalSecurityException);
        }
    }

    static Key buildUnwrappedKey(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeySpecException {
        switch (n) {
            case 3: {
                return Utils.buildUnwrappedSecretKey(byArray, string);
            }
            case 1: {
                return Utils.buildUnwrappedPublicKey(byArray, string);
            }
            case 2: {
                return Utils.buildUnwrappedPrivateKey(byArray, string);
            }
        }
        throw new IllegalArgumentException("Unexpected key type: " + n);
    }

    static SecretKey buildUnwrappedSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    static PublicKey buildUnwrappedPublicKey(byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
    }

    static PrivateKey buildUnwrappedPrivateKey(byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
    }

    static byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("arrays must be the same length");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    static byte[] decodeHex(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Input length must be even");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    private static void assertArrayEquals(String string, byte[] byArray, byte[] byArray2) {
        if (!Arrays.equals(byArray, byArray2)) {
            throw new AssertionError((Object)("Arrays do not match: " + string));
        }
    }

    public static void testMac(Mac mac, SecretKey secretKey, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        int n2;
        int n32;
        mac.init(secretKey);
        int[] nArray = new int[]{1, 3, 4, 7, 8, 16, 32, 48, 64, 128, 256};
        String string = mac.getAlgorithm();
        Utils.assertArrayEquals(string, byArray2, mac.doFinal(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            mac.update(byArray[i]);
        }
        Utils.assertArrayEquals(string + "-Byte", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(byArray, n32, n2);
            }
            Utils.assertArrayEquals(string + "-" + n4, byArray2, mac.doFinal());
        }
        mac.update(ByteBuffer.wrap(byArray));
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(ByteBuffer.wrap(byArray, n32, n2));
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-" + n4, byArray2, mac.doFinal());
        }
        mac.update(ByteBuffer.wrap(byArray).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(ByteBuffer.wrap(byArray, n32, n2).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO-" + n4, byArray2, mac.doFinal());
        }
        Object object = ByteBuffer.allocate(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocate(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect-" + n32, byArray2, mac.doFinal());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, mac.doFinal());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update(((ByteBuffer)object).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update(((ByteBuffer)object).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, mac.doFinal());
        }
    }

    public static void testDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n32;
        int[] nArray = new int[]{1, 3, 4, 7, 8, 16, 32, 48, 64, 128, 256};
        String string = messageDigest.getAlgorithm();
        Utils.assertArrayEquals(string, byArray2, messageDigest.digest(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            messageDigest.update(byArray[i]);
        }
        Utils.assertArrayEquals(string + "-Byte", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(byArray, n32, n2);
            }
            Utils.assertArrayEquals(string + "-" + n4, byArray2, messageDigest.digest());
        }
        messageDigest.update(ByteBuffer.wrap(byArray));
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(ByteBuffer.wrap(byArray, n32, n2));
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-" + n4, byArray2, messageDigest.digest());
        }
        messageDigest.update(ByteBuffer.wrap(byArray).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(ByteBuffer.wrap(byArray, n32, n2).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO-" + n4, byArray2, messageDigest.digest());
        }
        Object object = ByteBuffer.allocate(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocate(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect-" + n32, byArray2, messageDigest.digest());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, messageDigest.digest());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update(((ByteBuffer)object).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update(((ByteBuffer)object).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, messageDigest.digest());
        }
    }

    static void zeroByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.clear();
        while (byteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer2 = ZERO_BYTE_BUF.duplicate();
            byteBuffer2.limit(Math.min(byteBuffer2.remaining(), byteBuffer.remaining()));
            byteBuffer.put(byteBuffer2);
        }
    }
}

