/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.SelfTestFailureException;
import com.amazon.corretto.crypto.provider.SelfTestResult;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import java.util.logging.Logger;

class SelfTestSuite {
    private static final Logger LOGGER = Logger.getLogger(SelfTestSuite.class.getName());
    private ConcurrentHashMap<String, SelfTest> selfTests = new ConcurrentHashMap();

    SelfTestSuite() {
    }

    void addSelfTest(SelfTest selfTest) {
        if (this.selfTests.putIfAbsent(selfTest.getAlgorithmName(), selfTest) != null) {
            throw new IllegalArgumentException("Duplicate test for algorithm " + selfTest.getAlgorithmName());
        }
    }

    public void resetAllSelfTests() {
        this.selfTests.values().forEach(object -> ((SelfTest)object).resetStatus());
    }

    public SelfTestStatus getOverallStatus() {
        if (this.selfTests.isEmpty()) {
            throw new IllegalStateException("No self-tests added");
        }
        SelfTestStatus selfTestStatus = SelfTestStatus.PASSED;
        for (SelfTest selfTest : this.selfTests.values()) {
            selfTestStatus = selfTestStatus.combineMultipleTests(selfTest.getCachedResult().getStatus());
        }
        return selfTestStatus;
    }

    public Map<String, SelfTestResult> getAllTestResults() {
        HashMap<String, SelfTestResult> hashMap = new HashMap<String, SelfTestResult>(this.selfTests.size());
        this.selfTests.forEach((string, selfTest) -> hashMap.put((String)string, selfTest.getCachedResult()));
        return hashMap;
    }

    public void assertAllTestsPassed() throws SelfTestFailureException {
        if (!this.runTests().equals((Object)SelfTestStatus.PASSED)) {
            Map<String, SelfTestResult> map = this.getAllTestResults();
            SelfTestFailureException selfTestFailureException = new SelfTestFailureException("Failed self-tests");
            for (Map.Entry<String, SelfTestResult> entry : map.entrySet()) {
                SelfTestResult selfTestResult = entry.getValue();
                if (selfTestResult.getStatus().equals((Object)SelfTestStatus.PASSED)) continue;
                selfTestFailureException.addSuppressed(new SelfTestFailureException("Self-test for " + entry.getKey() + " failed: " + selfTestResult, selfTestResult.getThrowable()));
            }
            throw selfTestFailureException;
        }
    }

    public SelfTestStatus runTests() {
        this.selfTests.forEach((string, selfTest) -> selfTest.runTest());
        return this.getOverallStatus();
    }

    static class SelfTest {
        private static final AtomicReferenceFieldUpdater<SelfTest, SelfTestResult> update_result = AtomicReferenceFieldUpdater.newUpdater(SelfTest.class, SelfTestResult.class, "result");
        private final String algorithmName;
        private final Supplier<SelfTestResult> selfTestRunner;
        private volatile SelfTestResult result;
        private ConcurrentHashMap<Thread, Object> activeThreads = new ConcurrentHashMap();

        public SelfTest(String string, Supplier<SelfTestResult> supplier) {
            this.algorithmName = string;
            this.selfTestRunner = supplier;
            this.resetStatus();
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SelfTestResult runTest() {
            SelfTestResult selfTestResult = this.result;
            if (selfTestResult.getStatus() != SelfTestStatus.NOT_RUN) {
                return selfTestResult;
            }
            if (this.activeThreads.putIfAbsent(Thread.currentThread(), true) != null) {
                return new SelfTestResult(SelfTestStatus.RECURSIVELY_INVOKED);
            }
            try {
                SelfTestResult selfTestResult3 = this.runTest0();
                SelfTestResult selfTestResult4 = update_result.updateAndGet(this, selfTestResult2 -> selfTestResult2.combine(selfTestResult3));
                return selfTestResult4;
            }
            finally {
                this.activeThreads.remove(Thread.currentThread());
            }
        }

        private SelfTestResult runTest0() {
            SelfTestResult selfTestResult = this.selfTestRunner.get();
            if (selfTestResult.getStatus() == SelfTestStatus.PASSED) {
                LOGGER.finer(() -> String.format("Self-test result for JCE algo %s: PASSED", this.getAlgorithmName()));
            } else {
                LOGGER.severe(() -> {
                    StringWriter stringWriter = new StringWriter();
                    stringWriter.append(String.format("Self-test result for JCE algo %s: %s", new Object[]{this.getAlgorithmName(), selfTestResult.getStatus()}));
                    if (selfTestResult.getThrowable() != null) {
                        stringWriter.append("\n");
                        selfTestResult.getThrowable().printStackTrace(new PrintWriter(stringWriter));
                    }
                    return stringWriter.toString();
                });
            }
            return selfTestResult;
        }

        public SelfTestResult getCachedResult() {
            return this.result;
        }

        public void assertSelfTestPassed() throws SelfTestFailureException {
            if (!SelfTestStatus.PASSED.equals((Object)this.runTest().getStatus())) {
                throw new SelfTestFailureException("Self-test for " + this.getAlgorithmName() + " failed: " + this.result, this.result.getThrowable());
            }
        }

        private void resetStatus() {
            this.result = new SelfTestResult(SelfTestStatus.NOT_RUN);
        }

        private void forceFailure() {
            this.result = new SelfTestResult(new RuntimeException("Forced failure"));
        }
    }
}

