/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;

class RsaGen
extends KeyPairGeneratorSpi {
    private final KeyFactory keyFactory;
    private final AmazonCorrettoCryptoProvider provider_;
    private RSAKeyGenParameterSpec kgSpec;

    RsaGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        try {
            this.keyFactory = KeyFactory.getInstance("RSA");
            this.kgSpec = new RSAKeyGenParameterSpec(2048, RSAKeyGenParameterSpec.F4);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    private static native void generate(int var0, boolean var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    @Override
    public KeyPair generateKeyPair() {
        int n = this.kgSpec.getKeysize();
        byte[] byArray = this.kgSpec.getPublicExponent().toByteArray();
        byte[] byArray2 = new byte[n / 8 + 1];
        byte[] byArray3 = new byte[n / 8 + 1];
        int n2 = n / 16 + 1;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = new byte[n2];
        byte[] byArray8 = new byte[n2];
        RsaGen.generate(n, this.provider_.hasExtraCheck(ExtraCheck.KEY_PAIR_GENERATION_CONSISTENCY), byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7, byArray8);
        BigInteger bigInteger = new BigInteger(byArray2);
        try {
            PublicKey publicKey = this.keyFactory.generatePublic(new RSAPublicKeySpec(bigInteger, this.kgSpec.getPublicExponent()));
            PrivateKey privateKey = this.keyFactory.generatePrivate(new RSAPrivateCrtKeySpec(bigInteger, this.kgSpec.getPublicExponent(), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8)));
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AssertionError((Object)invalidKeySpecException);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameterSpec: " + algorithmParameterSpec);
        }
        this.kgSpec = RsaGen.validateParameter((RSAKeyGenParameterSpec)algorithmParameterSpec);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            this.kgSpec = RsaGen.validateParameter(new RSAKeyGenParameterSpec(n, RSAKeyGenParameterSpec.F4));
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static RSAKeyGenParameterSpec validateParameter(RSAKeyGenParameterSpec rSAKeyGenParameterSpec) throws InvalidAlgorithmParameterException {
        if (rSAKeyGenParameterSpec.getKeysize() < 512) {
            throw new InvalidAlgorithmParameterException("Unsupported key size: " + rSAKeyGenParameterSpec.getKeysize());
        }
        return rSAKeyGenParameterSpec;
    }

    static {
        Loader.load();
    }
}

