/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.Utils;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

class RsaCipher
extends CipherSpi {
    private static final int HANDLE_USAGE_IGNORE = 1;
    private static final int HANDLE_USAGE_USE = 2;
    private static final int HANDLE_USAGE_CREATE = 3;
    private static final KeyFactory KEY_FACTORY;
    private final AmazonCorrettoCryptoProvider provider_;
    private final Object lock_ = new Object();
    private final Padding padding_;
    private int mode_;
    private RSAKey key_;
    private int keySizeBytes_;
    private NativeRsaKey nativeKey_;
    private AccessibleByteArrayOutputStream buffer_;
    byte[] n;
    byte[] e;
    byte[] d;
    byte[] p;
    byte[] q;
    byte[] dmp1;
    byte[] dmq1;
    byte[] iqmp;
    private boolean reUseKey_ = false;

    private static native void releaseNativeKey(long var0);

    private static native int cipher(int var0, byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, boolean var7, long[] var8, int var9, byte[] var10, byte[] var11, byte[] var12, byte[] var13, byte[] var14, byte[] var15, byte[] var16, byte[] var17);

    RsaCipher(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, Padding padding) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.padding_ = padding;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
            try {
                int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
                if (n3 == byArray2.length) {
                    return byArray2;
                }
                return Arrays.copyOf(byArray2, n3);
            }
            catch (ShortBufferException shortBufferException) {
                throw new AssertionError((Object)shortBufferException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Object object = this.lock_;
        synchronized (object) {
            int n4;
            this.assertInitialized();
            try {
                this.parseKey();
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException);
            }
            if (this.buffer_.size() != 0) {
                if (byArray != null) {
                    this.buffer_.write(byArray, n, n2);
                }
                byArray = this.buffer_.getDataBuffer();
                n = 0;
                n2 = this.buffer_.size();
            }
            if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
                throw new ShortBufferException();
            }
            if (this.mode_ == 1 || this.mode_ == 3) {
                if (n2 > this.keySizeBytes_ - this.padding_.paddingLength) {
                    throw new BadPaddingException("Data must not be longer than " + (this.keySizeBytes_ - this.padding_.paddingLength) + " bytes");
                }
                if (this.padding_.equals((Object)Padding.NO_PADDING) && n2 < this.keySizeBytes_) {
                    byte[] byArray3 = new byte[this.keySizeBytes_];
                    System.arraycopy(byArray, n, byArray3, this.keySizeBytes_ - n2, n2);
                    byArray = byArray3;
                    n = 0;
                    n2 = this.keySizeBytes_;
                }
            } else if (n2 > this.keySizeBytes_) {
                throw new BadPaddingException("Input length is too long.");
            }
            if (this.nativeKey_ != null) {
                n4 = this.cipherWithNativeKey(byArray, n, n2, byArray2, n3);
            } else if (!this.reUseKey_) {
                n4 = this.cipherWithRawParams(byArray, n, n2, byArray2, n3);
                this.reUseKey_ = true;
            } else {
                n4 = this.cipherAndCreateNativeKey(byArray, n, n2, byArray2, n3);
            }
            this.buffer_ = new AccessibleByteArrayOutputStream();
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cipherWithNativeKey(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        Object object = this.lock_;
        synchronized (object) {
            if (this.nativeKey_ == null) {
                throw new IllegalStateException("cipherWithNativeKey must only be called with a non-null nativeKey_");
            }
            return this.nativeKey_.use(l -> RsaCipher.cipher(this.mode_, byArray, n, n2, byArray2, n3, this.padding_.nativeVal, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), new long[]{l}, 2, null, null, null, null, null, null, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cipherWithRawParams(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        Object object = this.lock_;
        synchronized (object) {
            return RsaCipher.cipher(this.mode_, byArray, n, n2, byArray2, n3, this.padding_.nativeVal, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), null, 1, this.n, this.e, this.d, this.p, this.q, this.dmp1, this.dmq1, this.iqmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cipherAndCreateNativeKey(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        Object object = this.lock_;
        synchronized (object) {
            long[] lArray = new long[1];
            int n4 = RsaCipher.cipher(this.mode_, byArray, n, n2, byArray2, n3, this.padding_.nativeVal, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), lArray, 3, this.n, this.e, this.d, this.p, this.q, this.dmp1, this.dmq1, this.iqmp);
            this.nativeKey_ = new NativeRsaKey(lArray[0]);
            return n4;
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new InvalidKeyException();
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineGetOutputSize(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            return this.keySizeBytes_;
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.padding_.equals((Object)Padding.OAEP_SHA1_MGF1)) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
                algorithmParameters.init(new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT));
                return algorithmParameters;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new AssertionError((Object)generalSecurityException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        Object object = this.lock_;
        synchronized (object) {
            if (!(key instanceof RSAKey)) {
                throw new InvalidKeyException();
            }
            this.mode_ = RsaCipher.checkMode(n, key);
            if (this.key_ != key) {
                if (this.nativeKey_ != null) {
                    this.nativeKey_.release();
                    this.nativeKey_ = null;
                }
                this.reUseKey_ = false;
                this.key_ = (RSAKey)((Object)key);
                this.keySizeBytes_ = (this.key_.getModulus().bitLength() + 7) / 8;
                this.buffer_ = new AccessibleByteArrayOutputStream();
                this.parseKey();
            }
        }
    }

    private static int checkMode(int n, Key key) throws InvalidKeyException {
        if (key instanceof PrivateKey) {
            switch (n) {
                case 2: 
                case 4: {
                    return n;
                }
                case 1: {
                    return -1 * n;
                }
            }
            throw new InvalidKeyException("Private keys not supported for mode " + n);
        }
        if (key instanceof PublicKey) {
            switch (n) {
                case 1: 
                case 3: {
                    return n;
                }
                case 2: {
                    return -1 * n;
                }
            }
            throw new InvalidKeyException("Public keys not supported for mode " + n);
        }
        throw new InvalidKeyException("Unsupported key type: " + key.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseKey() throws InvalidKeyException {
        Object object = this.lock_;
        synchronized (object) {
            if (this.nativeKey_ != null && !this.nativeKey_.isReleased()) {
                return;
            }
            this.n = null;
            this.e = null;
            this.d = null;
            this.p = null;
            this.q = null;
            this.dmp1 = null;
            this.dmq1 = null;
            this.iqmp = null;
            if (this.key_ instanceof PrivateKey) {
                RSAPrivateKeySpec rSAPrivateKeySpec;
                boolean bl = false;
                try {
                    rSAPrivateKeySpec = KEY_FACTORY.getKeySpec((Key)((Object)this.key_), RSAPrivateCrtKeySpec.class);
                    this.n = rSAPrivateKeySpec.getModulus().toByteArray();
                    this.e = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getPublicExponent().toByteArray();
                    this.d = rSAPrivateKeySpec.getPrivateExponent().toByteArray();
                    this.p = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getPrimeP().toByteArray();
                    this.q = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getPrimeQ().toByteArray();
                    this.dmp1 = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getPrimeExponentP().toByteArray();
                    this.dmq1 = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getPrimeExponentQ().toByteArray();
                    this.iqmp = ((RSAPrivateCrtKeySpec)rSAPrivateKeySpec).getCrtCoefficient().toByteArray();
                    bl = true;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    // empty catch block
                }
                if (!bl) {
                    try {
                        rSAPrivateKeySpec = KEY_FACTORY.getKeySpec((Key)((Object)this.key_), RSAPrivateKeySpec.class);
                        this.n = rSAPrivateKeySpec.getModulus().toByteArray();
                        this.d = rSAPrivateKeySpec.getPrivateExponent().toByteArray();
                        bl = true;
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    throw new InvalidKeyException("Unable to parse the key " + this.key_);
                }
            } else if (this.key_ instanceof PublicKey) {
                try {
                    RSAPublicKeySpec rSAPublicKeySpec = KEY_FACTORY.getKeySpec((Key)((Object)this.key_), RSAPublicKeySpec.class);
                    this.n = rSAPublicKeySpec.getModulus().toByteArray();
                    this.e = rSAPublicKeySpec.getPublicExponent().toByteArray();
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    throw new InvalidKeyException(invalidKeySpecException);
                }
            } else {
                throw new IllegalArgumentException("Unexpected key type: " + this.key_.getClass());
            }
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof OAEPParameterSpec && this.padding_.equals((Object)Padding.OAEP_SHA1_MGF1)) {
                OAEPParameterSpec oAEPParameterSpec = (OAEPParameterSpec)algorithmParameterSpec;
                if (!("SHA-1".equalsIgnoreCase(oAEPParameterSpec.getDigestAlgorithm()) && "MGF1".equalsIgnoreCase(oAEPParameterSpec.getMGFAlgorithm()) && oAEPParameterSpec.getMGFParameters() != null && oAEPParameterSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException();
                }
                MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)oAEPParameterSpec.getMGFParameters();
                if (!MGF1ParameterSpec.SHA1.getDigestAlgorithm().equals(mGF1ParameterSpec.getDigestAlgorithm())) {
                    throw new InvalidAlgorithmParameterException();
                }
                PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
                PSource pSource = oAEPParameterSpec.getPSource();
                if (pSource == null || !pSpecified.getAlgorithm().equalsIgnoreCase(pSource.getAlgorithm())) {
                    throw new InvalidAlgorithmParameterException();
                }
            } else {
                throw new InvalidAlgorithmParameterException();
            }
        }
        this.engineInit(n, key, secureRandom);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, algorithmParameters.getParameterSpec(OAEPParameterSpec.class), secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"ECB".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!this.padding_.jceName.equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            this.buffer_.write(byArray, n, n2);
        }
        return Utils.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            this.buffer_.write(byArray, n, n2);
        }
        return 0;
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.mode_ != 4 && this.mode_ != 2) {
            throw new IllegalStateException("Cipher must be in UNWRAP_MODE");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Utils.buildUnwrappedKey(byArray2, string, n);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrapping failed", generalSecurityException);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.mode_ != 3 && this.mode_ != 1) {
            throw new IllegalStateException("Cipher must be in WRAP_MODE");
        }
        try {
            byte[] byArray = Utils.encodeForWrapping(key);
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInitialized() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.key_ == null) {
                throw new IllegalStateException();
            }
        }
    }

    static {
        Loader.load();
        try {
            KEY_FACTORY = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    static class OAEPSha1
    extends RsaCipher {
        OAEPSha1(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.OAEP_SHA1_MGF1);
        }
    }

    static class Pkcs1
    extends RsaCipher {
        Pkcs1(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.PKCS1);
        }
    }

    static class NoPadding
    extends RsaCipher {
        NoPadding(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.NO_PADDING);
        }
    }

    private static class NativeRsaKey
    extends NativeResource {
        protected NativeRsaKey(long l2) {
            super(l2, l -> RsaCipher.releaseNativeKey(l));
        }
    }

    private static enum Padding {
        PKCS1(1, "PKCS1Padding", 11),
        NO_PADDING(3, "NoPadding", 0),
        OAEP_SHA1_MGF1(4, "OAEPWithSHA-1AndMGF1Padding", 42);

        private final int nativeVal;
        private final String jceName;
        private final int paddingLength;

        private Padding(int n2, String string2, int n3) {
            this.nativeVal = n2;
            this.jceName = string2;
            this.paddingLength = n3;
        }
    }
}

