/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Janitor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;

class NativeResource {
    private static final Janitor RESOURCE_JANITOR = new Janitor();
    private final Cell cell;
    private final Janitor.Mess mess;

    private static void wakeCleaner() {
        RESOURCE_JANITOR.wake();
    }

    protected NativeResource(long l, LongConsumer longConsumer) {
        this.cell = new Cell(l, longConsumer);
        this.mess = RESOURCE_JANITOR.register(this, this.cell::release);
    }

    boolean isReleased() {
        return this.cell.isReleased();
    }

    <T> T use(LongFunction<T> longFunction) {
        return this.cell.use(longFunction);
    }

    void useVoid(LongConsumer longConsumer) {
        Object object = this.cell.use(l -> {
            longConsumer.accept(l);
            return null;
        });
    }

    long take() {
        long l = this.cell.take();
        this.mess.clean();
        return l;
    }

    void release() {
        this.mess.clean();
    }

    private static final class Cell
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        private final long ptr;
        private final LongConsumer releaser;
        private boolean released;

        private Cell(long l, LongConsumer longConsumer) {
            if (l == 0L) {
                throw new AssertionError((Object)"ptr must not be equal to zero");
            }
            this.ptr = l;
            this.releaser = longConsumer;
            this.released = false;
        }

        public void release() {
            this.lock();
            try {
                if (this.released) {
                    return;
                }
                this.released = true;
                this.releaser.accept(this.ptr);
            }
            finally {
                this.unlock();
            }
        }

        public long take() {
            this.lock();
            try {
                if (this.released) {
                    throw new IllegalStateException("Use after free");
                }
                this.released = true;
                long l = this.ptr;
                return l;
            }
            finally {
                this.unlock();
            }
        }

        public boolean isReleased() {
            this.lock();
            try {
                boolean bl = this.released;
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        public <T> T use(LongFunction<T> longFunction) {
            this.lock();
            try {
                if (this.released) {
                    throw new IllegalStateException("Use after free");
                }
                T t = longFunction.apply(this.ptr);
                return t;
            }
            finally {
                this.unlock();
            }
        }
    }
}

