/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.util.Arrays;

public final class MD5Spi
extends MessageDigestSpi
implements Cloneable {
    private static final String HASH_NAME = "MD5";
    private static final int HASH_SIZE;
    private static final byte[] INITIAL_CONTEXT;
    private InputBuffer<byte[], byte[]> buffer;

    static native void fastDigest(byte[] var0, byte[] var1, int var2);

    private static native int getHashSize();

    private static native int getContextSize();

    private static native void initContext(byte[] var0);

    private static native void updateContextByteArray(byte[] var0, byte[] var1, int var2, int var3);

    private static native void updateNativeByteBuffer(byte[] var0, ByteBuffer var1);

    private static native void finish(byte[] var0, byte[] var1, int var2);

    public MD5Spi() {
        Loader.checkNativeLibraryAvailability();
        this.buffer = new InputBuffer(1024).withInitialStateSupplier(() -> (byte[])INITIAL_CONTEXT.clone()).withUpdater(MD5Spi::updateContextByteArray).withUpdater(MD5Spi::updateNativeByteBuffer).withDoFinal(byArray -> {
            byte[] byArray2 = new byte[HASH_SIZE];
            MD5Spi.finish(byArray, byArray2, 0);
            return byArray2;
        }).withSinglePass((byArray, n, n2) -> {
            if (n != 0 || n2 != byArray.length) {
                byArray = Arrays.copyOf(byArray, n2);
                n = 0;
            }
            byte[] byArray2 = new byte[HASH_SIZE];
            MD5Spi.fastDigest(byArray2, byArray, byArray.length);
            return byArray2;
        }).withStateCloner(byArray -> (byte[])byArray.clone());
    }

    @Override
    protected void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.update(byArray, n, n2);
    }

    @Override
    protected synchronized void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.update(byteBuffer);
    }

    @Override
    protected int engineGetDigestLength() {
        return HASH_SIZE;
    }

    @Override
    public synchronized Object clone() {
        try {
            MD5Spi mD5Spi = (MD5Spi)super.clone();
            mD5Spi.buffer = (InputBuffer)this.buffer.clone();
            return mD5Spi;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Unexpected CloneNotSupportedException", cloneNotSupportedException);
        }
    }

    @Override
    protected synchronized byte[] engineDigest() {
        try {
            byte[] byArray = this.buffer.doFinal();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected synchronized int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < HASH_SIZE) {
            throw new IllegalArgumentException("Buffer length too small");
        }
        byte[] byArray2 = this.engineDigest();
        try {
            System.arraycopy(byArray2, 0, byArray, n, HASH_SIZE);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(arrayIndexOutOfBoundsException);
        }
        return HASH_SIZE;
    }

    @Override
    protected synchronized void engineReset() {
        this.buffer.reset();
    }

    static {
        Loader.checkNativeLibraryAvailability();
        INITIAL_CONTEXT = new byte[MD5Spi.getContextSize()];
        MD5Spi.initContext(INITIAL_CONTEXT);
        HASH_SIZE = MD5Spi.getHashSize();
    }
}

