/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class Loader {
    private static final String RESOURCE_PATH = "com/amazon/corretto/crypto/provider/";
    private static final String PROPERTY_BASE = "com.amazon.corretto.crypto.provider.";
    private static final String LIBRARY_NAME = "amazonCorrettoCryptoProvider";
    private static final Pattern TEST_FILENAME_PATTERN = Pattern.compile("[-a-zA-Z0-9]+(\\.[a-zA-Z0-9]+)*");
    private static final Logger LOG = Logger.getLogger("AmazonCorrettoCryptoProvider");
    private static final Pattern OLD_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)\\.\\d+");
    @Deprecated
    static final double PROVIDER_VERSION;
    static final String PROVIDER_VERSION_STR;
    static final boolean IS_AVAILABLE;
    static final Throwable LOADING_ERROR;

    Loader() {
    }

    static InputStream getTestData(String string) {
        if (!TEST_FILENAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("Invalid filename: " + string);
        }
        InputStream inputStream = AccessController.doPrivileged(() -> Loader.class.getResourceAsStream("/test-data/" + string));
        if (inputStream == null) {
            throw new AssertionError((Object)("Unable to load test data from file /test-data/" + string));
        }
        return inputStream;
    }

    static String getProperty(String string) {
        return AccessController.doPrivileged(() -> System.getProperty(PROPERTY_BASE + string));
    }

    static String getProperty(String string, String string2) {
        return AccessController.doPrivileged(() -> System.getProperty(PROPERTY_BASE + string, string2));
    }

    static void load() {
    }

    static void checkNativeLibraryAvailability() {
        if (!IS_AVAILABLE) {
            throw new UnsupportedOperationException("Native library not available");
        }
    }

    private static native String getNativeLibraryVersion();

    private static void assertVersionMatch() {
        String string;
        try {
            string = Loader.getNativeLibraryVersion();
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        if (!PROVIDER_VERSION_STR.equals(string)) {
            throw new AssertionError((Object)String.format("Library version mismatch. Java: %s, Native: %s", PROVIDER_VERSION_STR, string));
        }
    }

    /*
     * Exception decompiling
     */
    private static synchronized Path createTmpFile(String var0, String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        boolean bl = false;
        Object object = null;
        String string = null;
        double d = 0.0;
        try {
            string = AccessController.doPrivileged(() -> {
                try (InputStream inputStream = Loader.class.getClassLoader().getResourceAsStream("com/amazon/corretto/crypto/provider/version.properties");){
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String string = properties.getProperty("versionStr");
                    return string;
                }
            });
            Matcher matcher = OLD_VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new AssertionError((Object)("Version string has wrong form: " + string));
            }
            d = Double.parseDouble(matcher.group(1));
            bl = AccessController.doPrivileged(() -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
        }
        catch (Throwable throwable) {
            bl = false;
            object = throwable;
        }
        PROVIDER_VERSION_STR = string;
        PROVIDER_VERSION = d;
        if (bl) {
            try {
                Loader.assertVersionMatch();
            }
            catch (AssertionError assertionError) {
                bl = false;
                object = assertionError;
            }
        }
        IS_AVAILABLE = bl;
        LOADING_ERROR = object;
        if (bl) {
            LOG.log(Level.CONFIG, "Successfully loaded native library version " + PROVIDER_VERSION_STR);
        } else {
            LOG.log(Level.CONFIG, "Unable to load native library", (Throwable)object);
        }
    }
}

