/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class InputBuffer<T, S>
implements Cloneable {
    private final int buffSize;
    private AccessibleByteArrayOutputStream buff;
    private boolean firstData = true;
    private S state;
    private ArrayStateConsumer<S> arrayUpdater;
    private FinalHandlerFunction<S, T> finalHandler;
    private Consumer<S> stateResetter = object -> {};
    private StateSupplier<S> stateSupplier = () -> null;
    private Optional<Function<S, S>> stateCloner = Optional.empty();
    private Optional<ByteBufferBiConsumer<S>> bufferUpdater = Optional.empty();
    private Optional<ArrayFunction<S>> initialArrayUpdater = Optional.empty();
    private Optional<ByteBufferFunction<S>> initialBufferUpdater = Optional.empty();
    private Optional<ArrayFunction<T>> singlePassArray = Optional.empty();

    InputBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Capacity must be non-negative");
        }
        this.buff = new AccessibleByteArrayOutputStream(0, n);
        this.buffSize = n;
    }

    public void reset() {
        this.buff.reset();
        this.firstData = true;
        if (this.state != null) {
            this.stateResetter.accept(this.state);
        }
        this.state = this.stateSupplier.get();
    }

    public InputBuffer<T, S> withInitialUpdater(ArrayFunction<S> arrayFunction) {
        this.initialArrayUpdater = Optional.ofNullable(arrayFunction);
        return this;
    }

    public InputBuffer<T, S> withUpdater(ArrayStateConsumer<S> arrayStateConsumer) {
        this.arrayUpdater = arrayStateConsumer;
        return this;
    }

    public InputBuffer<T, S> withInitialUpdater(ByteBufferFunction<S> byteBufferFunction) {
        this.initialBufferUpdater = Optional.ofNullable(byteBufferFunction);
        return this;
    }

    public InputBuffer<T, S> withUpdater(ByteBufferBiConsumer<S> byteBufferBiConsumer) {
        this.bufferUpdater = Optional.ofNullable(byteBufferBiConsumer);
        return this;
    }

    public InputBuffer<T, S> withDoFinal(FinalHandlerFunction<S, T> finalHandlerFunction) {
        this.finalHandler = finalHandlerFunction;
        return this;
    }

    public InputBuffer<T, S> withSinglePass(ArrayFunction<T> arrayFunction) {
        this.singlePassArray = Optional.ofNullable(arrayFunction);
        return this;
    }

    public InputBuffer<T, S> withStateCloner(Function<S, S> function) {
        this.stateCloner = Optional.ofNullable(function);
        return this;
    }

    public InputBuffer<T, S> withStateResetter(Consumer<S> consumer) {
        this.stateResetter = consumer;
        return this;
    }

    public InputBuffer<T, S> withInitialStateSupplier(StateSupplier<S> stateSupplier) {
        this.stateSupplier = stateSupplier;
        return this;
    }

    private boolean fillBuffer(byte[] byArray, int n, int n2) {
        if (this.buffSize - this.buff.size() < n2) {
            return false;
        }
        try {
            this.buff.write(byArray, n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.toString());
        }
        return true;
    }

    private boolean fillBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.buffSize - this.buff.size() < n) {
            return false;
        }
        this.buff.write(byteBuffer);
        return true;
    }

    private void processBuffer(boolean bl) {
        if (this.firstData && (bl || this.buff.size() > 0)) {
            if (this.initialArrayUpdater.isPresent()) {
                this.state = this.initialArrayUpdater.get().apply(this.buff.getDataBuffer(), 0, this.buff.size());
                this.buff.reset();
            } else {
                this.state = this.stateSupplier.get();
            }
            this.firstData = false;
        }
        if (this.buff.size() > 0) {
            this.arrayUpdater.accept(this.state, this.buff.getDataBuffer(), 0, this.buff.size());
            this.buff.reset();
        }
    }

    public void update(ByteBuffer byteBuffer) {
        try {
            if (!byteBuffer.isDirect() || this.firstData && !this.initialBufferUpdater.isPresent() && !this.bufferUpdater.isPresent() || !this.firstData && !this.bufferUpdater.isPresent()) {
                ShimArray shimArray = new ShimArray(byteBuffer);
                this.update(shimArray.array, shimArray.offset, shimArray.length);
                return;
            }
            if (this.fillBuffer(byteBuffer)) {
                return;
            }
            this.processBuffer(false);
            if (this.fillBuffer(byteBuffer)) {
                return;
            }
            if (this.firstData) {
                if (this.initialBufferUpdater.isPresent()) {
                    this.state = this.initialBufferUpdater.get().apply(byteBuffer.slice());
                } else {
                    this.state = this.stateSupplier.get();
                    this.bufferUpdater.get().accept(this.state, byteBuffer.slice());
                }
            } else {
                this.bufferUpdater.get().accept(this.state, byteBuffer.slice());
            }
            this.firstData = false;
        }
        finally {
            byteBuffer.position(byteBuffer.limit());
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.fillBuffer(byArray, n, n2)) {
            return;
        }
        this.processBuffer(false);
        if (this.fillBuffer(byArray, n, n2)) {
            return;
        }
        if (this.firstData) {
            if (this.initialArrayUpdater.isPresent()) {
                this.state = this.initialArrayUpdater.get().apply(byArray, n, n2);
            } else {
                this.state = this.stateSupplier.get();
                this.arrayUpdater.accept(this.state, byArray, n, n2);
            }
        } else {
            this.arrayUpdater.accept(this.state, byArray, n, n2);
        }
        this.firstData = false;
    }

    public T doFinal() {
        if (!this.firstData || !this.singlePassArray.isPresent()) {
            this.processBuffer(true);
            return this.finalHandler.apply(this.state);
        }
        return this.singlePassArray.get().apply(this.buff.getDataBuffer(), 0, this.buff.size());
    }

    protected Object clone() throws CloneNotSupportedException {
        if (!this.stateCloner.isPresent()) {
            throw new CloneNotSupportedException("No stateCloner configured");
        }
        InputBuffer inputBuffer = (InputBuffer)super.clone();
        inputBuffer.state = this.state != null ? this.stateCloner.get().apply(this.state) : null;
        inputBuffer.buff = this.buff.clone();
        return inputBuffer;
    }

    private static class ShimArray {
        private final ByteBuffer backingBuffer;
        public final byte[] array;
        public final int offset;
        public final int length;

        public ShimArray(ByteBuffer byteBuffer) {
            byte[] byArray;
            this.backingBuffer = byteBuffer.slice();
            this.length = this.backingBuffer.limit();
            boolean bl = this.backingBuffer.hasArray();
            byte[] byArray2 = byArray = bl ? this.backingBuffer.array() : null;
            if (byArray == null) {
                byArray = new byte[this.length];
                this.backingBuffer.duplicate().get(byArray);
                this.offset = 0;
            } else {
                this.offset = this.backingBuffer.arrayOffset() + this.backingBuffer.position();
            }
            this.array = byArray;
        }
    }

    @FunctionalInterface
    public static interface StateSupplier<S>
    extends Supplier<S> {
        @Override
        public S get();
    }

    @FunctionalInterface
    public static interface ByteBufferBiConsumer<S>
    extends BiConsumer<S, ByteBuffer> {
        @Override
        public void accept(S var1, ByteBuffer var2);
    }

    @FunctionalInterface
    public static interface ByteBufferFunction<S>
    extends Function<ByteBuffer, S> {
        @Override
        public S apply(ByteBuffer var1);
    }

    public static interface FinalHandlerFunction<T, R>
    extends Function<T, R> {
        @Override
        public R apply(T var1);
    }

    @FunctionalInterface
    public static interface ArrayFunction<T> {
        public T apply(byte[] var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface ArrayStateConsumer<S> {
        public void accept(S var1, byte[] var2, int var3, int var4);
    }
}

