/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.SHA256Spi;
import com.amazon.corretto.crypto.provider.SelfTestResult;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HmacSHA256Spi
extends MacSpi {
    private static final String MAC_NAME = "HmacSHA256";
    private static final int HASH_SIZE;
    private static final int BLOCK_SIZE;
    static final SelfTestSuite.SelfTest SELF_TEST;
    private static final byte[] INITIAL_CONTEXT;
    private static Throwable selfTestThrowable;
    private byte[] oneByteArray = null;
    private final State baseState = new State();
    private final InputBuffer<byte[], Void> buffer;

    private static native int getContextSize();

    private static native int getBlockSize();

    private static native int getHashSize();

    private static native void initContext(byte[] var0);

    private static native void updateCtxArray(byte[] var0, byte[] var1, byte[] var2, int var3, int var4);

    private static native void updateCtxBuffer(byte[] var0, byte[] var1, ByteBuffer var2);

    private static native void doFinal(byte[] var0, byte[] var1, byte[] var2);

    private static native void fastHmac(byte[] var0, byte[] var1, int var2, int var3, byte[] var4);

    public static SelfTestResult runSelfTest() {
        TestMacProvider testMacProvider = new TestMacProvider();
        int n = 0;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap.put("HmacMD5", "md5");
        hashMap2.put("HmacMD5", 0);
        hashMap.put("HmacSHA1", "sha1");
        hashMap2.put("HmacSHA1", 0);
        hashMap.put(MAC_NAME, "sha2");
        hashMap2.put(MAC_NAME, 0);
        hashMap.put("HmacSHA384", "sha2");
        hashMap2.put("HmacSHA384", 1);
        hashMap.put("HmacSHA512", "sha2");
        hashMap2.put("HmacSHA512", 2);
        Scanner scanner = new Scanner(Loader.getTestData("hmac.txt"), StandardCharsets.US_ASCII.name());
        try {
            Object object;
            Mac mac = Mac.getInstance(MAC_NAME, testMacProvider);
            while (scanner.hasNext()) {
                ++n;
                object = scanner.next();
                SecretKeySpec secretKeySpec = new SecretKeySpec(Utils.decodeHex(scanner.next()), MAC_NAME);
                byte[] byArray = Utils.decodeHex(scanner.next());
                String[] stringArray = scanner.nextLine().trim().split("\\s+");
                if (!((String)object).equals(hashMap.get(MAC_NAME))) continue;
                Utils.testMac(mac, secretKeySpec, byArray, Utils.decodeHex(stringArray[(Integer)hashMap2.get(MAC_NAME)]));
            }
            object = new SelfTestResult(SelfTestStatus.PASSED);
            scanner.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                Logger.getLogger("AmazonCorrettoCryptoProvider").severe("HmacSHA256 failed self-test " + n);
                return new SelfTestResult(throwable3);
            }
        }
    }

    public HmacSHA256Spi() {
        this(false);
    }

    private HmacSHA256Spi(boolean bl) {
        if (!bl) {
            SELF_TEST.assertSelfTestPassed();
        }
        this.buffer = new InputBuffer(1024).withInitialUpdater((byArray, n, n2) -> {
            this.assertInitialized();
            HmacSHA256Spi.updateCtxArray(this.baseState.ctx, this.baseState.normalKey, byArray, n, n2);
            return null;
        }).withInitialUpdater(byteBuffer -> {
            this.assertInitialized();
            HmacSHA256Spi.updateCtxBuffer(this.baseState.ctx, this.baseState.normalKey, byteBuffer);
            return null;
        }).withUpdater((void_, byArray, n, n2) -> {
            this.assertInitialized();
            HmacSHA256Spi.updateCtxArray(this.baseState.ctx, null, byArray, n, n2);
        }).withUpdater((void_, byteBuffer) -> {
            this.assertInitialized();
            HmacSHA256Spi.updateCtxBuffer(this.baseState.ctx, null, byteBuffer);
        }).withDoFinal(void_ -> {
            this.assertInitialized();
            byte[] byArray = new byte[HASH_SIZE];
            HmacSHA256Spi.doFinal(this.baseState.ctx, this.baseState.normalKey, byArray);
            this.baseState.reset();
            return byArray;
        }).withSinglePass((byArray, n, n2) -> {
            this.assertInitialized();
            byte[] byArray2 = new byte[HASH_SIZE];
            HmacSHA256Spi.fastHmac(this.baseState.normalKey, byArray, n, n2, byArray2);
            this.baseState.reset();
            return byArray2;
        });
    }

    private void assertInitialized() {
        if (!this.baseState.initialized) {
            throw new IllegalStateException("Mac not initialized");
        }
    }

    @Override
    protected synchronized byte[] engineDoFinal() {
        try {
            byte[] byArray = this.buffer.doFinal();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected synchronized int engineGetMacLength() {
        return HASH_SIZE;
    }

    @Override
    protected synchronized void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Params must be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Hmac uses expects a SecretKey");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Key must support RAW encoding");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Key encoding must not be null");
        }
        this.baseState.setKey(byArray);
        this.engineReset();
    }

    @Override
    protected synchronized void engineReset() {
        this.buffer.reset();
    }

    @Override
    protected synchronized void engineUpdate(byte by) {
        if (this.oneByteArray == null) {
            this.oneByteArray = new byte[1];
        }
        this.oneByteArray[0] = by;
        this.engineUpdate(this.oneByteArray, 0, 1);
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this.buffer.update(byArray, n, n2);
    }

    @Override
    protected synchronized void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.update(byteBuffer);
    }

    static {
        SELF_TEST = new SelfTestSuite.SelfTest(MAC_NAME, HmacSHA256Spi::runSelfTest);
        selfTestThrowable = null;
        INITIAL_CONTEXT = new byte[HmacSHA256Spi.getContextSize()];
        HmacSHA256Spi.initContext(INITIAL_CONTEXT);
        HASH_SIZE = HmacSHA256Spi.getHashSize();
        BLOCK_SIZE = HmacSHA256Spi.getBlockSize();
    }

    private static class State {
        final byte[] normalKey = new byte[HmacSHA256Spi.access$100()];
        final byte[] ctx = (byte[])HmacSHA256Spi.access$200().clone();
        boolean initialized = false;

        private State() {
        }

        public void setKey(byte[] byArray) {
            Arrays.fill(this.normalKey, (byte)0);
            if (byArray.length > BLOCK_SIZE) {
                SHA256Spi.fastDigest(this.normalKey, byArray, byArray.length);
            } else {
                System.arraycopy(byArray, 0, this.normalKey, 0, byArray.length);
            }
            this.initialized = true;
        }

        public void reset() {
            System.arraycopy(INITIAL_CONTEXT, 0, this.ctx, 0, INITIAL_CONTEXT.length);
        }
    }

    private static class TestMacProvider
    extends Provider {
        protected TestMacProvider() {
            super("test provider", 0.0, "internal self-test provider");
        }

        @Override
        public synchronized Provider.Service getService(String string, String string2) {
            if (string.equals("Mac") && string2.equals(HmacSHA256Spi.MAC_NAME)) {
                return new Provider.Service(this, string, string2, HmacSHA256Spi.class.getName(), Collections.emptyList(), Collections.emptyMap()){

                    @Override
                    public Object newInstance(Object object) {
                        return new HmacSHA256Spi(true);
                    }
                };
            }
            return super.getService(string, string2);
        }
    }
}

