/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpSignatureBase;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import java.nio.ByteBuffer;
import java.security.SignatureException;

class EvpSignatureRaw
extends EvpSignatureBase {
    private final AmazonCorrettoCryptoProvider provider_;
    private AccessibleByteArrayOutputStream buffer = new AccessibleByteArrayOutputStream(64, 0x100000);

    private EvpSignatureRaw(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n) {
        super(evpKeyType, n);
        this.provider_ = amazonCorrettoCryptoProvider;
    }

    @Override
    protected void engineReset() {
        this.buffer.reset();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.buffer.write(by & 0xFF);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.buffer.write(byArray, n, n2);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.buffer.write(byteBuffer);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] byArray = EvpSignatureRaw.signRaw(this.keyDer_, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.paddingType_, null, 0, this.buffer.getDataBuffer(), 0, this.buffer.size());
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            boolean bl = EvpSignatureRaw.verifyRaw(this.keyDer_, this.keyType_.nativeValue, this.paddingType_, null, 0, this.buffer.getDataBuffer(), 0, this.buffer.size(), byArray, n, n2);
            return bl;
        }
        finally {
            this.engineReset();
        }
    }

    private static native byte[] signRaw(byte[] var0, int var1, boolean var2, int var3, String var4, int var5, byte[] var6, int var7, int var8);

    private static native boolean verifyRaw(byte[] var0, int var1, int var2, String var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    static final class NONEwithDSA
    extends EvpSignatureRaw {
        NONEwithDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0);
        }
    }

    static final class NONEwithECDSA
    extends EvpSignatureRaw {
        NONEwithECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0);
        }
    }
}

