/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.NativeResource;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

abstract class EvpSignatureBase
extends SignatureSpi {
    protected static final int RSA_PKCS1_PADDING = 1;
    protected final EvpKeyType keyType_;
    protected final int paddingType_;
    protected Key key_ = null;
    protected byte[] keyDer_ = null;
    protected boolean signMode;
    protected int keyUsageCount_ = 0;
    protected EvpContext ctx_ = null;

    EvpSignatureBase(EvpKeyType evpKeyType, int n) {
        this.keyType_ = evpKeyType;
        this.paddingType_ = n;
    }

    protected abstract void engineReset();

    private static native void destroyContext(long var0);

    @Override
    protected synchronized void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.key_ != privateKey) {
            if (!this.keyType_.jceName.equalsIgnoreCase(privateKey.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.keyUsageCount_ = 0;
            if (this.ctx_ != null) {
                this.ctx_.release();
                this.ctx_ = null;
            }
            this.key_ = privateKey;
            try {
                this.keyDer_ = this.keyType_.getKeyFactory().getKeySpec(privateKey, PKCS8EncodedKeySpec.class).getEncoded();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                this.key_ = null;
                this.keyDer_ = null;
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        this.signMode = true;
        this.engineReset();
    }

    @Override
    protected synchronized void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (this.key_ != publicKey) {
            if (!this.keyType_.jceName.equalsIgnoreCase(publicKey.getAlgorithm())) {
                throw new InvalidKeyException();
            }
            this.keyUsageCount_ = 0;
            if (this.ctx_ != null) {
                this.ctx_.release();
                this.ctx_ = null;
            }
            this.key_ = publicKey;
            try {
                this.keyDer_ = this.keyType_.getKeyFactory().getKeySpec(publicKey, X509EncodedKeySpec.class).getEncoded();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                this.key_ = null;
                this.keyDer_ = null;
                throw new InvalidKeyException(invalidKeySpecException);
            }
        }
        this.signMode = false;
        this.engineReset();
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected synchronized void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameters supported by this algorithm");
        }
    }

    @Override
    protected synchronized AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void ensureInitialized(Boolean bl) throws SignatureException {
        if (this.key_ == null) {
            throw new SignatureException("Not initialized");
        }
        if (bl != null && bl != this.signMode) {
            throw new SignatureException("Incorrect mode for operation");
        }
    }

    protected static final class EvpContext
    extends NativeResource {
        protected EvpContext(long l2) {
            super(l2, l -> EvpSignatureBase.destroyContext(l));
        }
    }
}

