/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.EvpSignatureBase;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.InputBuffer;
import com.amazon.corretto.crypto.provider.Loader;
import java.nio.ByteBuffer;
import java.security.SignatureException;

class EvpSignature
extends EvpSignatureBase {
    private static final int KEY_REUSE_THRESHOLD = 1;
    private final AmazonCorrettoCryptoProvider provider_;
    private final String digestName_;
    private final byte[] oneByteArray_ = new byte[1];
    private final InputBuffer<byte[], Void> signingBuffer;
    private final InputBuffer<Boolean, Void> verifyingBuffer;

    private static native byte[] sign(byte[] var0, long[] var1, int var2, boolean var3, String var4, int var5, String var6, int var7, byte[] var8, int var9, int var10);

    private static native boolean verify(byte[] var0, long[] var1, int var2, String var3, int var4, String var5, int var6, byte[] var7, int var8, int var9, byte[] var10, int var11, int var12);

    private static native long signStart(byte[] var0, long var1, int var3, boolean var4, String var5, int var6, String var7, int var8, byte[] var9, int var10, int var11);

    private static native long signStartBuffer(byte[] var0, long var1, int var3, boolean var4, String var5, int var6, String var7, int var8, ByteBuffer var9);

    private static native long verifyStart(byte[] var0, long var1, int var3, String var4, int var5, String var6, int var7, byte[] var8, int var9, int var10);

    private static native long verifyStartBuffer(byte[] var0, long var1, int var3, String var4, int var5, String var6, int var7, ByteBuffer var8);

    private static native void signUpdate(long var0, byte[] var2, int var3, int var4);

    private static native void signUpdateBuffer(long var0, ByteBuffer var2);

    private static native void verifyUpdate(long var0, byte[] var2, int var3, int var4);

    private static native void verifyUpdateBuffer(long var0, ByteBuffer var2);

    private static native byte[] signFinish(long var0, boolean var2);

    private static native boolean verifyFinish(long var0, byte[] var2, int var3, int var4, boolean var5);

    private EvpSignature(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, EvpKeyType evpKeyType, int n4, String string) {
        super(evpKeyType, n4);
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.digestName_ = string;
        this.signingBuffer = new InputBuffer(1024).withInitialUpdater((byArray, n, n2) -> {
            if (this.ctx_ == null) {
                this.ctx_ = new EvpSignatureBase.EvpContext(EvpSignature.signStart(this.keyDer_, 0L, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, this.paddingType_, null, 0, byArray, n, n2));
            } else {
                this.ctx_.use(l -> EvpSignature.signStart(this.keyDer_, l, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, this.paddingType_, null, 0, byArray, n, n2));
            }
            return null;
        }).withInitialUpdater(byteBuffer -> {
            if (this.ctx_ == null) {
                this.ctx_ = new EvpSignatureBase.EvpContext(EvpSignature.signStartBuffer(this.keyDer_, 0L, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, this.paddingType_, null, 0, byteBuffer));
            } else {
                this.ctx_.use(l -> EvpSignature.signStartBuffer(this.keyDer_, l, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, this.paddingType_, null, 0, byteBuffer));
            }
            return null;
        }).withUpdater((void_, byArray, n, n2) -> this.ctx_.useVoid(l -> EvpSignature.signUpdate(l, byArray, n, n2))).withUpdater((void_, byteBuffer) -> this.ctx_.useVoid(l -> EvpSignature.signUpdateBuffer(l, byteBuffer))).withDoFinal(void_ -> {
            byte[] byArray;
            if (this.keyUsageCount_ > 1) {
                byArray = this.ctx_.use(l -> EvpSignature.signFinish(l, true));
            } else {
                try {
                    byArray = EvpSignature.signFinish(this.ctx_.take(), false);
                }
                finally {
                    this.ctx_ = null;
                }
            }
            ++this.keyUsageCount_;
            return byArray;
        }).withSinglePass((byArray, n2, n3) -> {
            byte[] byArray2;
            if (this.ctx_ != null) {
                byArray2 = this.ctx_.use(l -> EvpSignature.sign(this.keyDer_, new long[]{l}, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, n4, null, 0, byArray, n2, n3));
            } else {
                long[] lArray = this.keyUsageCount_ > 1 ? new long[1] : null;
                byArray2 = EvpSignature.sign(this.keyDer_, lArray, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY), this.digestName_, n4, null, 0, byArray, n2, n3);
                if (lArray != null) {
                    this.ctx_ = new EvpSignatureBase.EvpContext(lArray[0]);
                }
            }
            ++this.keyUsageCount_;
            return byArray2;
        });
        this.verifyingBuffer = new InputBuffer(1024).withInitialUpdater((byArray, n, n2) -> {
            if (this.ctx_ != null) {
                this.ctx_.use(l -> EvpSignature.verifyStart(this.keyDer_, l, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byArray, n, n2));
            } else {
                this.ctx_ = new EvpSignatureBase.EvpContext(EvpSignature.verifyStart(this.keyDer_, 0L, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byArray, n, n2));
            }
            return null;
        }).withInitialUpdater(byteBuffer -> {
            if (this.ctx_ != null) {
                this.ctx_.use(l -> EvpSignature.verifyStartBuffer(this.keyDer_, l, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byteBuffer));
            } else {
                this.ctx_ = new EvpSignatureBase.EvpContext(EvpSignature.verifyStartBuffer(this.keyDer_, 0L, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byteBuffer));
            }
            return null;
        }).withUpdater((void_, byArray, n, n2) -> this.ctx_.useVoid(l -> EvpSignature.verifyUpdate(l, byArray, n, n2))).withUpdater((void_, byteBuffer) -> this.ctx_.useVoid(l -> EvpSignature.verifyUpdateBuffer(l, byteBuffer)));
    }

    @Override
    protected synchronized void engineReset() {
        this.signingBuffer.reset();
        this.verifyingBuffer.reset();
    }

    @Override
    protected synchronized byte[] engineSign() throws SignatureException {
        this.ensureInitialized(true);
        try {
            byte[] byArray = this.signingBuffer.doFinal();
            return byArray;
        }
        finally {
            this.engineReset();
        }
    }

    @Override
    protected synchronized void engineUpdate(byte by) throws SignatureException {
        this.oneByteArray_[0] = by;
        this.engineUpdate(this.oneByteArray_, 0, 1);
    }

    @Override
    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInitialized(null);
        if (this.signMode) {
            this.signingBuffer.update(byArray, n, n2);
        } else {
            this.verifyingBuffer.update(byArray, n, n2);
        }
    }

    @Override
    protected synchronized void engineUpdate(ByteBuffer byteBuffer) {
        if (this.signMode) {
            this.signingBuffer.update(byteBuffer);
        } else {
            this.verifyingBuffer.update(byteBuffer);
        }
    }

    @Override
    protected synchronized boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        this.ensureInitialized(false);
        try {
            boolean bl = this.verifyingBuffer.withDoFinal(void_ -> {
                boolean bl;
                if (this.keyUsageCount_ > 1) {
                    bl = this.ctx_.use(l -> EvpSignature.verifyFinish(l, byArray, n, n2, true));
                } else {
                    try {
                        bl = EvpSignature.verifyFinish(this.ctx_.take(), byArray, n, n2, false);
                    }
                    finally {
                        this.ctx_ = null;
                    }
                }
                ++this.keyUsageCount_;
                return bl;
            }).withSinglePass((byArray2, n3, n4) -> {
                boolean bl;
                if (this.ctx_ != null) {
                    bl = this.ctx_.use(l -> EvpSignature.verify(this.keyDer_, new long[]{l}, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byArray2, n3, n4, byArray, n, n2));
                } else {
                    long[] lArray = this.keyUsageCount_ > 1 ? new long[1] : null;
                    bl = EvpSignature.verify(this.keyDer_, lArray, this.keyType_.nativeValue, this.digestName_, this.paddingType_, null, 0, byArray2, n3, n4, byArray, n, n2);
                    if (lArray != null) {
                        this.ctx_ = new EvpSignatureBase.EvpContext(lArray[0]);
                    }
                }
                ++this.keyUsageCount_;
                return bl;
            }).doFinal();
            return bl;
        }
        finally {
            this.verifyingBuffer.withDoFinal(null).withSinglePass(null);
            this.engineReset();
        }
    }

    static final class SHA512withDSA
    extends EvpSignature {
        SHA512withDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0, "sha512");
        }
    }

    static final class SHA384withDSA
    extends EvpSignature {
        SHA384withDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0, "sha384");
        }
    }

    static final class SHA256withDSA
    extends EvpSignature {
        SHA256withDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0, "sha256");
        }
    }

    static final class SHA224withDSA
    extends EvpSignature {
        SHA224withDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0, "sha224");
        }
    }

    static final class SHA1withDSA
    extends EvpSignature {
        SHA1withDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.DSA, 0, "sha1");
        }
    }

    static final class SHA512withECDSA
    extends EvpSignature {
        SHA512withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha512");
        }
    }

    static final class SHA384withECDSA
    extends EvpSignature {
        SHA384withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha384");
        }
    }

    static final class SHA256withECDSA
    extends EvpSignature {
        SHA256withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha256");
        }
    }

    static final class SHA224withECDSA
    extends EvpSignature {
        SHA224withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha224");
        }
    }

    static final class SHA1withECDSA
    extends EvpSignature {
        SHA1withECDSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.EC, 0, "sha1");
        }
    }

    static final class SHA512withRSA
    extends EvpSignature {
        SHA512withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha512");
        }
    }

    static final class SHA384withRSA
    extends EvpSignature {
        SHA384withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha384");
        }
    }

    static final class SHA256withRSA
    extends EvpSignature {
        SHA256withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha256");
        }
    }

    static final class SHA224withRSA
    extends EvpSignature {
        SHA224withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha224");
        }
    }

    static final class SHA1withRSA
    extends EvpSignature {
        SHA1withRSA(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, EvpKeyType.RSA, 1, "sha1");
        }
    }
}

