/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

enum EvpKeyType {
    RSA("RSA", 6, RSAPublicKey.class, RSAPrivateKey.class),
    DH("DH", 28, DHPublicKey.class, DHPrivateKey.class),
    DSA("DSA", 116, DSAPublicKey.class, DSAPrivateKey.class),
    EC("EC", 408, ECPublicKey.class, ECPrivateKey.class);

    final String jceName;
    final int nativeValue;
    final Class<? extends PublicKey> publicKeyClass;
    final Class<? extends PrivateKey> privateKeyClass;
    private final KeyFactory factory;

    private EvpKeyType(String string2, int n2, Class<? extends PublicKey> clazz, Class<? extends PrivateKey> clazz2) {
        this.jceName = string2;
        this.nativeValue = n2;
        this.publicKeyClass = clazz;
        this.privateKeyClass = clazz2;
        try {
            this.factory = KeyFactory.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)("KeyFactory for " + string2 + " not available"));
        }
    }

    KeyFactory getKeyFactory() {
        return this.factory;
    }
}

