/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;

class EvpKeyAgreement
extends KeyAgreementSpi {
    private static final int[] AES_KEYSIZES_BYTES = new int[]{16, 24, 32};
    private static final Pattern ALGORITHM_WITH_EXPLICIT_KEYSIZE = Pattern.compile("(\\S+?)(?:\\[(\\d+)\\])?");
    private final AmazonCorrettoCryptoProvider provider_;
    private final EvpKeyType keyType_;
    private final String algorithm_;
    private PrivateKey privKey = null;
    private byte[] privKeyDer = null;
    private byte[] secret = null;

    private static native byte[] agree(byte[] var0, byte[] var1, int var2, boolean var3) throws InvalidKeyException;

    EvpKeyAgreement(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, String string, EvpKeyType evpKeyType) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.algorithm_ = string;
        this.keyType_ = evpKeyType;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        byte[] byArray;
        if (this.privKey == null) {
            throw new IllegalStateException("KeyAgreement has not been initialized");
        }
        if (!this.keyType_.publicKeyClass.isAssignableFrom(key.getClass())) {
            throw new InvalidKeyException("Expected key of type " + this.keyType_.publicKeyClass + " not " + key.getClass());
        }
        try {
            byArray = this.keyType_.getKeyFactory().getKeySpec(key, X509EncodedKeySpec.class).getEncoded();
        }
        catch (NullPointerException | InvalidKeySpecException exception) {
            throw new InvalidKeyException(exception);
        }
        if (bl) {
            this.secret = EvpKeyAgreement.agree(this.privKeyDer, byArray, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY));
            return null;
        }
        if ("DH".equals(this.algorithm_)) {
            DHParameterSpec dHParameterSpec = ((DHKey)((Object)this.privKey)).getParams();
            try {
                PublicKey publicKey = this.keyType_.getKeyFactory().generatePublic(new DHPublicKeySpec(new BigInteger(1, EvpKeyAgreement.agree(this.privKeyDer, byArray, this.keyType_.nativeValue, this.provider_.hasExtraCheck(ExtraCheck.PRIVATE_KEY_CONSISTENCY))), dHParameterSpec.getP(), dHParameterSpec.getG()));
                return publicKey;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new RuntimeCryptoException(invalidKeySpecException);
            }
        }
        this.secret = null;
        throw new IllegalStateException("Only single phase agreement is supported");
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("KeyAgreement has not been initialized");
        }
        if (this.secret == null) {
            throw new IllegalStateException("KeyAgreement has not been completed");
        }
        byte[] byArray = this.secret;
        this.reset();
        return byArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected SecretKey engineGenerateSecret(String var1_1) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        block11: {
            var2_2 = this.engineGenerateSecret();
            if (var1_1.equalsIgnoreCase("TlsPremasterSecret")) {
                if (this.algorithm_.equals("DH")) {
                    var2_2 = EvpKeyAgreement.trimZeros(var2_2);
                }
                return new SecretKeySpec(var2_2, "TlsPremasterSecret");
            }
            var3_3 = EvpKeyAgreement.ALGORITHM_WITH_EXPLICIT_KEYSIZE.matcher(var1_1);
            if (!var3_3.matches()) break block11;
            var4_4 = var3_3.group(1);
            var5_5 = -1;
            switch (var4_4.hashCode()) {
                case 64687: {
                    if (!var4_4.equals("AES")) break;
                    var5_5 = 0;
                }
            }
            switch (var5_5) {
                case 0: {
                    var6_6 = var3_3.group(2);
                    var7_7 = 0;
                    var8_8 = false;
                    if (var6_6 == null) ** GOTO lbl26
                    var7_7 = Integer.parseInt(var6_6);
                    for (int var12_15 : EvpKeyAgreement.AES_KEYSIZES_BYTES) {
                        if (var12_15 != var7_7) continue;
                        var8_8 = true;
                        ** GOTO lbl31
                    }
                    ** GOTO lbl31
lbl26:
                    // 3 sources

                    for (int var12_16 : EvpKeyAgreement.AES_KEYSIZES_BYTES) {
                        if (var12_16 > var2_2.length) continue;
                        var7_7 = var12_16;
                        var8_8 = true;
                    }
lbl31:
                    // 3 sources

                    if (!var8_8 || var7_7 > var2_2.length) {
                        throw new InvalidKeyException("Invalid key length");
                    }
                    return new SecretKeySpec(var2_2, 0, var7_7, "AES");
                }
            }
            throw new InvalidKeyException("Unsupported algorithm: " + var3_3.group(1));
        }
        throw new InvalidKeyException("Unrecognized algorithm: " + var1_1);
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        byte[] byArray2 = this.engineGenerateSecret();
        if (byArray.length - n < byArray2.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        this.reset();
        return byArray2.length;
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!this.keyType_.privateKeyClass.isAssignableFrom(key.getClass())) {
            throw new InvalidKeyException("Expected key of type " + this.keyType_.privateKeyClass + " not " + key.getClass());
        }
        this.privKey = (PrivateKey)key;
        try {
            this.privKeyDer = this.keyType_.getKeyFactory().getKeySpec(key, PKCS8EncodedKeySpec.class).getEncoded();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException);
        }
        this.reset();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No algorithm parameter spec expected");
        }
        this.engineInit(key, secureRandom);
    }

    protected void reset() {
        this.secret = null;
    }

    private static byte[] trimZeros(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        return Arrays.copyOfRange(byArray, n, byArray.length);
    }

    static class DH
    extends EvpKeyAgreement {
        DH(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, "DH", EvpKeyType.DH);
        }
    }

    static class ECDH
    extends EvpKeyAgreement {
        ECDH(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, "ECDH", EvpKeyType.EC);
        }
    }
}

