/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class EcUtils {
    private static final BigInteger MAX_COFACTOR = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final Pattern NIST_CURVE_PATTERN = Pattern.compile("(?:NIST )?(.)-(\\d+)");
    private static final ConcurrentHashMap<String, ECInfo> EC_INFO_CACHE = new ConcurrentHashMap();
    private static final Function<String, ECInfo> EC_INFO_LOADER = new Function<String, ECInfo>(){

        @Override
        public ECInfo apply(String string) {
            ECParameterSpec eCParameterSpec;
            Object object;
            Object object2;
            int[] nArray = new int[1];
            byte[] byArray = new byte[128];
            byte[] byArray2 = new byte[128];
            byte[] byArray3 = new byte[128];
            byte[] byArray4 = new byte[128];
            byte[] byArray5 = new byte[128];
            byte[] byArray6 = new byte[128];
            byte[] byArray7 = new byte[128];
            int n = EcUtils.curveNameToInfo(this.normalizeName(string), nArray, byArray, byArray2, byArray3, byArray4, byArray5, byArray6, byArray7);
            ECGenParameterSpec eCGenParameterSpec = new ECGenParameterSpec(string);
            if (n != 0) {
                BigInteger bigInteger = new BigInteger(byArray4);
                if (bigInteger.compareTo(MAX_COFACTOR) > 0) {
                    throw new IllegalArgumentException("Requested curve has a cofactor which is too large. Curve: " + string + " cofactor " + bigInteger);
                }
                object2 = nArray[0] != 0 ? new ECFieldF2m(nArray[0], new BigInteger(byArray)) : new ECFieldFp(new BigInteger(byArray));
                object = new EllipticCurve((ECField)object2, new BigInteger(byArray2), new BigInteger(byArray3));
                ECPoint eCPoint = new ECPoint(new BigInteger(byArray5), new BigInteger(byArray6));
                eCParameterSpec = new ECParameterSpec((EllipticCurve)object, eCPoint, new BigInteger(byArray7), bigInteger.intValue());
            } else {
                eCParameterSpec = null;
            }
            try {
                object = AlgorithmParameters.getInstance("EC");
                ((AlgorithmParameters)object).init(eCGenParameterSpec);
                object2 = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                if (eCParameterSpec != null) {
                    object2 = eCParameterSpec;
                }
                throw new IllegalArgumentException("Invalid curve name: " + string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeCryptoException(noSuchAlgorithmException);
            }
            return new ECInfo(string, (ECParameterSpec)object2, n);
        }

        private String normalizeName(String string) {
            Matcher matcher = NIST_CURVE_PATTERN.matcher(string);
            if (matcher.matches()) {
                switch (matcher.group(1)) {
                    case "P": {
                        return "secp" + matcher.group(2) + "r1";
                    }
                    case "K": {
                        return "sect" + matcher.group(2) + "k1";
                    }
                    case "B": {
                        if ("163".equals(matcher.group(2))) {
                            return "sect163r2";
                        }
                        return "sect" + matcher.group(2) + "r1";
                    }
                }
                return string;
            }
            if (string.startsWith("X9.62 ")) {
                return string.substring(6);
            }
            return string;
        }
    };

    private static native int curveNameToInfo(String var0, int[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8);

    private static native long buildGroup(int var0);

    private static native void freeGroup(long var0);

    private EcUtils() {
    }

    static ECInfo getSpecByName(String string) {
        return EC_INFO_CACHE.computeIfAbsent(string, EC_INFO_LOADER);
    }

    static final class NativeGroup
    extends NativeResource {
        protected NativeGroup(long l2) {
            super(l2, l -> EcUtils.freeGroup(l));
        }
    }

    static final class ECInfo {
        private final ThreadLocal<NativeGroup> group = new ThreadLocal<NativeGroup>(){

            @Override
            protected NativeGroup initialValue() {
                if (nid != 0) {
                    return new NativeGroup(EcUtils.buildGroup(nid));
                }
                return null;
            }
        };
        final String name;
        final ECParameterSpec spec;
        final int nid;

        private ECInfo(String string, ECParameterSpec eCParameterSpec, int n) {
            this.name = string;
            this.spec = eCParameterSpec;
            this.nid = n;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.nid);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ECInfo eCInfo = (ECInfo)object;
            if (!Objects.equals(this.name, eCInfo.name)) {
                return false;
            }
            return Objects.equals(this.nid, eCInfo.nid);
        }

        NativeGroup getGroup() {
            return this.group.get();
        }

        public String toString() {
            return "ECInfo [name=" + this.name + ", spec=" + this.spec + ", nid=" + this.nid + "]";
        }
    }
}

