/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EcUtils;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class EcGen
extends KeyPairGeneratorSpi {
    private static final ECGenParameterSpec DEFAULT_SPEC = new ECGenParameterSpec("secp384r1");
    private static final ConcurrentHashMap<EcUtils.ECInfo, ThreadLocal<NativeParams>> PARAM_CACHE = new ConcurrentHashMap();
    private static final Function<EcUtils.ECInfo, ThreadLocal<NativeParams>> CACHE_LOADER = eCInfo -> new ThreadLocal<NativeParams>(){

        @Override
        protected NativeParams initialValue() {
            return new NativeParams(EcGen.buildEcParams(eCInfo.nid));
        }
    };
    private final AmazonCorrettoCryptoProvider provider_;
    private final KeyFactory keyFactory;
    private ECParameterSpec spec = null;
    private byte[] encodedSpec = null;
    private EcUtils.ECInfo ecInfo = null;

    private static native long buildEcParams(int var0);

    private static native void freeEcParams(long var0);

    private static native void generateEcKey(long var0, long var2, boolean var4, byte[] var5, byte[] var6, byte[] var7);

    private static native void generateEcKeyFromSpec(byte[] var0, boolean var1, byte[] var2, byte[] var3, byte[] var4);

    EcGen(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        this.provider_ = amazonCorrettoCryptoProvider;
        try {
            this.keyFactory = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        if (this.spec == null) {
            try {
                this.initialize(DEFAULT_SPEC, null);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeCryptoException(invalidAlgorithmParameterException);
            }
        }
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[128];
        byte[] byArray3 = new byte[128];
        boolean bl = this.provider_.hasExtraCheck(ExtraCheck.KEY_PAIR_GENERATION_CONSISTENCY);
        if (this.encodedSpec != null) {
            EcGen.generateEcKeyFromSpec(this.encodedSpec, bl, byArray, byArray2, byArray3);
        } else {
            object2 = this.ecInfo.getGroup();
            object = EcGen.getParams(this.ecInfo);
            ((NativeResource)object2).useVoid(arg_0 -> EcGen.lambda$generateKeyPair$2((NativeParams)object, bl, byArray, byArray2, byArray3, arg_0));
        }
        object2 = new ECPoint(new BigInteger(byArray), new BigInteger(byArray2));
        object = new ECPrivateKeySpec(new BigInteger(byArray3), this.spec);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec((ECPoint)object2, this.spec);
        try {
            return new KeyPair(this.keyFactory.generatePublic(eCPublicKeySpec), this.keyFactory.generatePrivate((KeySpec)object));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new AssertionError((Object)invalidKeySpecException);
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)algorithmParameterSpec;
            if (eCGenParameterSpec.getName() == null) {
                throw new NullPointerException("Curve name may not be null");
            }
            try {
                this.ecInfo = EcUtils.getSpecByName(eCGenParameterSpec.getName());
                this.spec = this.ecInfo.spec;
                this.encodedSpec = this.ecInfo.nid == 0 ? EcGen.encodeSpec(this.spec) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + eCGenParameterSpec.getName(), illegalArgumentException);
            }
        } else if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.ecInfo = null;
            this.spec = (ECParameterSpec)algorithmParameterSpec;
            this.encodedSpec = EcGen.encodeSpec(this.spec);
        } else {
            throw new InvalidAlgorithmParameterException("Unsupported parameter spec: " + algorithmParameterSpec);
        }
    }

    private static byte[] encodeSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("EC");
            algorithmParameters.init(algorithmParameterSpec);
            return algorithmParameters.getEncoded();
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new RuntimeCryptoException(exception);
        }
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            String string = n == 192 || n == 256 ? "secp" + n + "k1" : "secp" + n + "r1";
            this.initialize(new ECGenParameterSpec(string), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    private static NativeParams getParams(EcUtils.ECInfo eCInfo) {
        return PARAM_CACHE.computeIfAbsent(eCInfo, CACHE_LOADER).get();
    }

    private static /* synthetic */ void lambda$generateKeyPair$2(NativeParams nativeParams, boolean bl, byte[] byArray, byte[] byArray2, byte[] byArray3, long l) {
        nativeParams.useVoid(l2 -> EcGen.generateEcKey(l2, l, bl, byArray, byArray2, byArray3));
    }

    private static final class NativeParams
    extends NativeResource {
        private NativeParams(long l2) {
            super(l2, (long l) -> EcGen.freeEcParams(l));
        }
    }
}

