/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AesCtrDrbg;
import com.amazon.corretto.crypto.provider.ExtraCheck;
import com.amazon.corretto.crypto.provider.HmacMD5Spi;
import com.amazon.corretto.crypto.provider.HmacSHA1Spi;
import com.amazon.corretto.crypto.provider.HmacSHA256Spi;
import com.amazon.corretto.crypto.provider.HmacSHA384Spi;
import com.amazon.corretto.crypto.provider.HmacSHA512Spi;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.RuntimeCryptoException;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.logging.Logger;

public final class AmazonCorrettoCryptoProvider
extends Provider {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final String PACKAGE_PREFIX = "com.amazon.corretto.crypto.provider.";
    private static final long serialVersionUID = 1L;
    public static final AmazonCorrettoCryptoProvider INSTANCE;
    public static final String PROVIDER_NAME = "AmazonCorrettoCryptoProvider";
    private static final boolean rdRandSupported_;
    private final EnumSet<ExtraCheck> extraChecks = EnumSet.noneOf(ExtraCheck.class);
    private transient SelfTestSuite selfTestSuite = new SelfTestSuite();

    private static native boolean nativeRdRandSupported();

    private void buildServiceMap() {
        this.addService("MessageDigest", "SHA-512", "SHA512Spi");
        this.addService("MessageDigest", "SHA-384", "SHA384Spi");
        this.addService("MessageDigest", "SHA-256", "SHA256Spi");
        this.addService("MessageDigest", "SHA-1", "SHA1Spi");
        this.addService("MessageDigest", "MD5", "MD5Spi");
        this.addService("Cipher", "AES/GCM/NoPadding", "AesGcmSpi");
        this.addService("Cipher", "AES_128/GCM/NoPadding", "AesGcmSpi");
        this.addService("Cipher", "AES_256/GCM/NoPadding", "AesGcmSpi");
        this.addService("KeyPairGenerator", "RSA", "RsaGen");
        this.addService("KeyPairGenerator", "EC", "EcGen");
        this.addService("Cipher", "RSA/ECB/NoPadding", "RsaCipher$NoPadding");
        this.addService("Cipher", "RSA/ECB/Pkcs1Padding", "RsaCipher$Pkcs1");
        this.addService("Cipher", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "RsaCipher$OAEPSha1");
        for (String string : new String[]{"MD5", "SHA1", "SHA256", "SHA384", "SHA512"}) {
            this.addService("Mac", "Hmac" + string, "Hmac" + string + "Spi");
        }
        this.addService("KeyAgreement", "ECDH", "EvpKeyAgreement$ECDH", Collections.singletonMap("SupportedKeyClasses", "java.security.interfaces.ECPublicKey|java.security.interfaces.ECPrivateKey"), new String[0]);
        this.addService("KeyAgreement", "DH", "EvpKeyAgreement$DH", Collections.emptyMap(), "DIFFIEHELLMAN");
        if (AmazonCorrettoCryptoProvider.isRdRandSupported()) {
            this.addService("SecureRandom", "NIST800-90A/AES-CTR-256", "AesCtrDrbg$SPI", Collections.singletonMap("ThreadSafe", "true"), new String[0]).setSelfTest(AesCtrDrbg.SPI.SELF_TEST);
        }
        this.addSignatures();
    }

    private void addSignatures() {
        List<String> list = Arrays.asList("DSA", "RSA", "ECDSA");
        List<String> list2 = Arrays.asList("SHA1", "SHA224", "SHA256", "SHA384", "SHA512");
        for (String string : list) {
            for (String string2 : list2) {
                String string3 = String.format("%swith%s", string2, string);
                this.addService("Signature", string3, String.format("EvpSignature$%s", string3));
            }
        }
        this.addService("Signature", "NONEwithECDSA", "EvpSignatureRaw$NONEwithECDSA");
        this.addService("Signature", "NONEwithDSA", "EvpSignatureRaw$NONEwithDSA");
    }

    private ACCPService addService(String string, String string2, String string3) {
        return this.addService(string, string2, string3, null, new String[0]);
    }

    private ACCPService addService(String string, String string2, String string3, Map<String, String> map, String ... stringArray) {
        ACCPService aCCPService = new ACCPService(string, string2, string3, Arrays.asList(stringArray), map);
        this.putService(aCCPService);
        return aCCPService;
    }

    private void resetAllSelfTests() {
        this.selfTestSuite.resetAllSelfTests();
    }

    public AmazonCorrettoCryptoProvider() {
        super(PROVIDER_NAME, Loader.PROVIDER_VERSION, "");
        String[] stringArray;
        for (String string : stringArray = Loader.getProperty("extrachecks", "").split(",")) {
            if (string.equalsIgnoreCase("all")) {
                this.extraChecks.addAll(EnumSet.allOf(ExtraCheck.class));
                break;
            }
            try {
                ExtraCheck extraCheck = ExtraCheck.valueOf(string.toUpperCase());
                if (extraCheck == null) continue;
                this.extraChecks.add(extraCheck);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!Loader.IS_AVAILABLE) {
            Logger.getLogger(PROVIDER_NAME).fine("Native JCE libraries are unavailable - disabling");
            return;
        }
        this.buildServiceMap();
        this.initializeSelfTests();
    }

    private synchronized void initializeSelfTests() {
        if (this.selfTestSuite == null) {
            this.selfTestSuite = new SelfTestSuite();
        }
        this.selfTestSuite.addSelfTest(HmacSHA512Spi.SELF_TEST);
        this.selfTestSuite.addSelfTest(HmacSHA384Spi.SELF_TEST);
        this.selfTestSuite.addSelfTest(HmacSHA256Spi.SELF_TEST);
        this.selfTestSuite.addSelfTest(HmacSHA1Spi.SELF_TEST);
        this.selfTestSuite.addSelfTest(HmacMD5Spi.SELF_TEST);
        if (AmazonCorrettoCryptoProvider.isRdRandSupported()) {
            this.selfTestSuite.addSelfTest(AesCtrDrbg.SPI.SELF_TEST);
        }
        ForkJoinPool.commonPool().submit(this.selfTestSuite::runTests);
    }

    @Override
    public String getVersionStr() {
        return Loader.PROVIDER_VERSION_STR;
    }

    public static void install() {
        Security.insertProviderAt(INSTANCE, 1);
    }

    public static boolean isRdRandSupported() {
        return rdRandSupported_;
    }

    public SelfTestStatus getSelfTestStatus() {
        return this.selfTestSuite.getOverallStatus();
    }

    public SelfTestStatus runSelfTests() {
        return this.selfTestSuite.runTests();
    }

    public Throwable getLoadingError() {
        return Loader.LOADING_ERROR;
    }

    public void assertHealthy() throws RuntimeCryptoException {
        if (Loader.LOADING_ERROR != null) {
            throw new RuntimeCryptoException("Unable to load native library", Loader.LOADING_ERROR);
        }
        this.selfTestSuite.assertAllTestsPassed();
    }

    @Override
    public synchronized boolean equals(Object object) {
        return this == object;
    }

    @Override
    public synchronized int hashCode() {
        return System.identityHashCode(this);
    }

    public Set<ExtraCheck> getExtraChecks() {
        return Collections.unmodifiableSet(this.extraChecks);
    }

    public boolean hasExtraCheck(ExtraCheck extraCheck) {
        return this.extraChecks.contains((Object)extraCheck);
    }

    public void addExtraChecks(ExtraCheck ... extraCheckArray) {
        this.extraChecks.addAll(Arrays.asList(extraCheckArray));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.readObjectNoData();
    }

    private void readObjectNoData() {
        this.initializeSelfTests();
    }

    static {
        if (!Loader.IS_AVAILABLE) {
            Logger.getLogger(PROVIDER_NAME).fine("Native JCE libraries are unavailable - disabling");
            rdRandSupported_ = false;
        } else {
            rdRandSupported_ = AmazonCorrettoCryptoProvider.nativeRdRandSupported();
        }
        INSTANCE = new AmazonCorrettoCryptoProvider();
    }

    private class ACCPService
    extends Provider.Service {
        private final MethodHandle ctor;
        private boolean failMessagePrinted;
        private volatile boolean testsPassed;
        private Supplier<SelfTestStatus> getTestStatus;

        public ACCPService(String string, String string2, String string3, List<String> list, Map<String, String> map) {
            super(AmazonCorrettoCryptoProvider.this, string, string2, AmazonCorrettoCryptoProvider.PACKAGE_PREFIX + string3, list, map);
            this.failMessagePrinted = false;
            this.testsPassed = false;
            this.getTestStatus = AmazonCorrettoCryptoProvider.this.selfTestSuite::runTests;
            try {
                MethodHandle methodHandle;
                Class<?> clazz = AmazonCorrettoCryptoProvider.class.getClassLoader().loadClass(AmazonCorrettoCryptoProvider.PACKAGE_PREFIX + string3);
                try {
                    methodHandle = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE)).asType(MethodType.methodType(Object.class));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    methodHandle = LOOKUP.findConstructor(clazz, MethodType.methodType(Void.TYPE, AmazonCorrettoCryptoProvider.class)).asType(MethodType.methodType(Object.class, AmazonCorrettoCryptoProvider.class)).bindTo(AmazonCorrettoCryptoProvider.this);
                }
                this.ctor = methodHandle;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (object != null) {
                throw new NoSuchAlgorithmException("Constructor parameters not used with " + this.getType() + "/" + this.getAlgorithm());
            }
            if (!this.testsPassed) {
                this.checkTests();
            }
            try {
                return this.ctor.invokeExact();
            }
            catch (Error | RuntimeException throwable) {
                throw throwable;
            }
            catch (Throwable throwable) {
                throw new NoSuchAlgorithmException("Unexpected error constructing algorithm", throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkTests() throws NoSuchAlgorithmException {
            if (this.inJarValidation() && !this.getType().equals("SecureRandom")) {
                throw new NoSuchAlgorithmException("Can't use AACP before JAR validation completes");
            }
            SelfTestStatus selfTestStatus = this.getTestStatus.get();
            switch (selfTestStatus) {
                case RECURSIVELY_INVOKED: {
                    throw new NoSuchAlgorithmException("Algorithm unavailable until self tests complete");
                }
                case FAILED: {
                    ACCPService aCCPService = this;
                    synchronized (aCCPService) {
                        if (!this.failMessagePrinted) {
                            Logger.getLogger(AmazonCorrettoCryptoProvider.PROVIDER_NAME).severe("Self tests failed - disabling. Detailed results: " + AmazonCorrettoCryptoProvider.this.selfTestSuite.getAllTestResults().toString());
                            this.failMessagePrinted = true;
                        }
                    }
                    throw new NoSuchAlgorithmException("Self-tests failed");
                }
                case NOT_RUN: {
                    throw new NoSuchAlgorithmException("Internal error: self tests not run");
                }
                case PASSED: {
                    this.testsPassed = true;
                }
            }
        }

        private boolean inJarValidation() {
            StackTraceElement[] stackTraceElementArray;
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                if (!stackTraceElement.getClassName().equals("javax.crypto.JarVerifier")) continue;
                return true;
            }
            return false;
        }

        public void setSelfTest(SelfTestSuite.SelfTest selfTest) {
            this.getTestStatus = () -> selfTest.runTest().getStatus();
        }
    }
}

