/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class AesGcmSpi
extends CipherSpi {
    private static final int KEY_REUSE_THRESHOLD = 1;
    private static final int DEFAULT_TAG_LENGTH = 128;
    private static final int NATIVE_MODE_ENCRYPT = 1;
    private static final int NATIVE_MODE_DECRYPT = 0;
    private static final int BLOCK_SIZE = 16;
    private NativeResource context = null;
    private SecretKey jceKey;
    private byte[] iv;
    private byte[] key;
    private int tagLength;
    private int opMode = -1;
    private boolean hasConsumedData = false;
    private boolean needReset = false;
    private int keyUsageCount = 0;
    private boolean contextInitialized = false;
    private AccessibleByteArrayOutputStream decryptInputBuf;
    private AccessibleByteArrayOutputStream decryptAADBuf;

    private static native int oneShotEncrypt(long var0, long[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, byte[] var9, byte[] var10);

    private static native int oneShotDecrypt(long var0, long[] var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8, byte[] var9, byte[] var10, byte[] var11, int var12);

    private static native long encryptInit(byte[] var0, byte[] var1);

    private static native void encryptInit(long var0, byte[] var2);

    private static native int encryptUpdate(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void encryptUpdateAAD(long var0, byte[] var2, int var3, int var4);

    private static native int encryptDoFinal(long var0, boolean var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    private static native void releaseContext(long var0);

    static native void configureLeakTracking(boolean var0);

    static native long getOutstandingInstanceCount();

    AesGcmSpi() {
        Loader.checkNativeLibraryAvailability();
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"GCM".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!"NoPadding".equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        switch (this.opMode) {
            case 1: {
                return n + Math.max(this.tagLength, this.engineGetBlockSize() - 1);
            }
            case 0: {
                return Math.max(0, this.decryptInputBuf.size() + n - this.tagLength);
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    private synchronized int getUpdateOutputSize(int n) {
        switch (this.opMode) {
            case 1: {
                return n + this.engineGetBlockSize() - 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    @Override
    protected byte[] engineGetIV() {
        return (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("GCM");
            algorithmParameters.init(new GCMParameterSpec(this.tagLength * 8, this.iv));
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new Error("Unexpected error", generalSecurityException);
        }
    }

    @Override
    protected synchronized void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 1 && n != 3) {
            throw new InvalidKeyException("IV required for decrypt");
        }
        byte[] byArray = new byte[12];
        secureRandom.nextBytes(byArray);
        try {
            this.engineInit(n, key, new GCMParameterSpec(128, byArray), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        GCMParameterSpec gCMParameterSpec;
        if (algorithmParameterSpec instanceof GCMParameterSpec) {
            gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            gCMParameterSpec = new GCMParameterSpec(128, ((IvParameterSpec)algorithmParameterSpec).getIV());
        } else {
            throw new InvalidAlgorithmParameterException("I don't know how to handle a " + algorithmParameterSpec.getClass());
        }
        byte[] byArray = null;
        if (this.jceKey != key) {
            if (!(key instanceof SecretKey)) {
                throw new InvalidKeyException("Need a SecretKey");
            }
            object = key.getAlgorithm();
            if (!"RAW".equalsIgnoreCase(key.getFormat())) {
                throw new InvalidKeyException("Need a raw format key");
            }
            if (!((String)object).equalsIgnoreCase("AES")) {
                throw new InvalidKeyException("Expected an AES key");
            }
            byArray = key.getEncoded();
            if (byArray == null) {
                throw new InvalidKeyException("Key doesn't support encoding");
            }
            if (!MessageDigest.isEqual(byArray, this.key)) {
                if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
                    throw new InvalidKeyException("Bad key length of " + byArray.length * 8 + " bits; expected 128, 192, or 256 bits");
                }
                this.keyUsageCount = 0;
                if (this.context != null) {
                    this.context.release();
                }
                this.context = null;
            } else {
                byArray = null;
            }
        }
        object = gCMParameterSpec.getIV();
        if (gCMParameterSpec.getTLen() % 8 != 0 || gCMParameterSpec.getTLen() > 128 || gCMParameterSpec.getTLen() < 96) {
            throw new InvalidAlgorithmParameterException("Unsupported TLen value; must be one of {128, 120, 112, 104, 96}");
        }
        if (this.iv != null && this.key != null && (n == 1 || n == 3) && Arrays.equals(this.iv, (byte[])object) && (byArray == null || MessageDigest.isEqual(this.key, byArray))) {
            throw new InvalidAlgorithmParameterException("Cannot reuse same iv and key for GCM encryption");
        }
        if (object == null || ((Object)object).length == 0) {
            throw new InvalidAlgorithmParameterException("IV must be at least one byte long");
        }
        switch (n) {
            case 1: 
            case 3: {
                this.opMode = 1;
                break;
            }
            case 2: 
            case 4: {
                this.opMode = 0;
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException("Unsupported cipher mode " + n);
            }
        }
        this.iv = (byte[])object;
        this.tagLength = gCMParameterSpec.getTLen() / 8;
        if (byArray != null) {
            this.key = byArray;
            this.jceKey = (SecretKey)key;
        }
        this.needReset = false;
        this.stateReset();
    }

    @Override
    protected synchronized void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, algorithmParameters.getParameterSpec(GCMParameterSpec.class), secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    @Override
    protected synchronized byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[this.getUpdateOutputSize(n2)];
        try {
            n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n3);
    }

    @Override
    protected synchronized int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.checkArrayLimits(byArray, n, n2);
        this.hasConsumedData = true;
        switch (this.opMode) {
            case 0: {
                this.decryptInputBuf.write(byArray, n, n2);
                return 0;
            }
            case 1: {
                int n4;
                byte[] byArray3;
                this.checkOutputBuffer(n2, byArray2, n3);
                this.lazyInit();
                if (Utils.arraysOverlap(byArray, n, byArray2, n3, this.engineGetOutputSize(n2))) {
                    byArray3 = Arrays.copyOfRange(byArray, n, n + n2);
                    n4 = 0;
                } else {
                    byArray3 = byArray;
                    n4 = n;
                }
                return this.context.use(l -> AesGcmSpi.encryptUpdate(l, byArray3, n4, n2, byArray2, n3));
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    @Override
    protected synchronized void engineUpdateAAD(byte[] byArray, int n, int n2) {
        this.checkArrayLimits(byArray, n, n2);
        if (this.hasConsumedData) {
            throw new IllegalStateException("AAD data cannot be updated after calling update()");
        }
        if (this.opMode == 0) {
            this.decryptAADBuf.write(byArray, n, n2);
            return;
        }
        this.lazyInit();
        this.internalUpdateAAD(byArray, n, n2);
    }

    private synchronized void internalUpdateAAD(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = Math.min(n2, 524288);
            int n4 = n;
            this.context.useVoid(l -> AesGcmSpi.encryptUpdateAAD(l, byArray, n4, n3));
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    protected synchronized void engineUpdateAAD(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.engineUpdateAAD(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.engineUpdateAAD(byArray, 0, byArray.length);
        }
        byteBuffer.position(byteBuffer.limit());
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        if (byArray == null) {
            byArray = Utils.EMPTY_ARRAY;
        }
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        try {
            n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (byArray == null) {
            byArray = Utils.EMPTY_ARRAY;
        }
        boolean bl = Utils.arraysOverlap(byArray, n, byArray2, n3, Math.max(n2, this.engineGetOutputSize(n2)));
        if (this.opMode != 1 && this.opMode != 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n3 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative output offset");
        }
        this.checkOutputBuffer(n2, byArray2, n3);
        this.checkArrayLimits(byArray, n, n2);
        int n4 = 0;
        if (bl) {
            n4 = this.engineUpdate(byArray, n, n2, byArray2, n3);
            n3 += n4;
            n2 = 0;
        }
        if (this.opMode == 0) {
            if (this.decryptInputBuf.size() != 0) {
                this.engineUpdate(byArray, n, n2);
                byArray = this.decryptInputBuf.getDataBuffer();
                n = 0;
                n2 = this.decryptInputBuf.size();
            }
            if (n2 < this.tagLength) {
                throw new AEADBadTagException("Input too short - need tag");
            }
            byte[] byArray3 = byArray;
            int n5 = n;
            int n6 = n3;
            int n7 = n2;
            ++this.keyUsageCount;
            if (this.context != null) {
                return this.context.use(l -> AesGcmSpi.oneShotDecrypt(l, null, byArray3, n5, n7, byArray2, n6, this.tagLength, this.key, this.iv, this.decryptAADBuf.size() != 0 ? this.decryptAADBuf.getDataBuffer() : Utils.EMPTY_ARRAY, this.decryptAADBuf.size()));
            }
            long[] lArray = this.keyUsageCount > 1 ? new long[1] : null;
            int n8 = AesGcmSpi.oneShotDecrypt(0L, lArray, byArray, n, n2, byArray2, n3, this.tagLength, this.key, this.iv, this.decryptAADBuf.size() != 0 ? this.decryptAADBuf.getDataBuffer() : Utils.EMPTY_ARRAY, this.decryptAADBuf.size());
            if (lArray != null) {
                this.context = new NativeContext(lArray[0]);
            }
            return n8;
        }
        this.checkNeedReset();
        this.needReset = true;
        byte[] byArray4 = byArray;
        int n9 = n;
        int n10 = n3;
        int n11 = n2;
        if (!this.contextInitialized) {
            ++this.keyUsageCount;
            if (this.context != null) {
                return this.context.use(l -> AesGcmSpi.oneShotEncrypt(l, null, byArray4, n9, n11, byArray2, n10, this.tagLength, this.key, this.iv));
            }
            long[] lArray = this.keyUsageCount > 1 ? new long[1] : null;
            int n12 = AesGcmSpi.oneShotEncrypt(0L, lArray, byArray4, n9, n11, byArray2, n10, this.tagLength, this.key, this.iv);
            if (lArray != null) {
                this.context = new NativeContext(lArray[0]);
            }
            return n12;
        }
        try {
            int n13;
            ++this.keyUsageCount;
            byte[] byArray5 = byArray;
            int n14 = n;
            int n15 = n2;
            int n16 = n3;
            if (this.keyUsageCount > 1) {
                n13 = this.context.use(l -> AesGcmSpi.encryptDoFinal(l, false, byArray5, n14, n15, byArray2, n16, this.tagLength));
            } else {
                n13 = AesGcmSpi.encryptDoFinal(this.context.take(), true, byArray, n, n2, byArray2, n3, this.tagLength);
                this.context = null;
            }
            int n17 = n4 + n13;
            return n17;
        }
        finally {
            this.stateReset();
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.opMode != 1) {
            throw new IllegalStateException("Cipher must be in WRAP_MODE");
        }
        try {
            byte[] byArray = Utils.encodeForWrapping(key);
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.opMode != 0) {
            throw new IllegalStateException("Cipher must be in UNWRAP_MODE");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Utils.buildUnwrappedKey(byArray2, string, n);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrapping failed", generalSecurityException);
        }
    }

    @Override
    protected synchronized int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        ByteBuffer byteBuffer3 = null;
        int n = byteBuffer2.position();
        if (byteBuffer2.remaining() < this.engineGetOutputSize(byteBuffer.remaining())) {
            throw new ShortBufferException();
        }
        if (Utils.buffersMaybeOverlap(byteBuffer, byteBuffer2)) {
            ByteBuffer byteBuffer4 = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer4.put(byteBuffer);
            byteBuffer4.flip();
            byteBuffer3 = byteBuffer = byteBuffer4;
        }
        while (byteBuffer.hasRemaining()) {
            int n2 = Math.min(byteBuffer.remaining(), 65536);
            ShimArray shimArray = new ShimArray(byteBuffer, n2);
            ShimArray shimArray2 = new ShimArray(byteBuffer2, this.engineGetOutputSize(n2));
            int n3 = this.engineUpdate(shimArray.array, shimArray.offset, shimArray.length, shimArray2.array, shimArray2.offset);
            shimArray2.writeback();
            byteBuffer.position(byteBuffer.position() + n2);
            byteBuffer2.position(byteBuffer2.position() + n3);
        }
        if (byteBuffer3 != null) {
            Utils.zeroByteBuffer(byteBuffer3);
        }
        return byteBuffer2.position() - n;
    }

    @Override
    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n = byteBuffer2.position();
        this.engineUpdate(byteBuffer, byteBuffer2);
        ShimArray shimArray = new ShimArray(byteBuffer2, this.engineGetOutputSize(0));
        int n2 = this.engineDoFinal(Utils.EMPTY_ARRAY, 0, 0, shimArray.array, shimArray.offset);
        shimArray.writeback();
        byteBuffer2.position(byteBuffer2.position() + n2);
        return byteBuffer2.position() - n;
    }

    private void checkOutputBuffer(int n, byte[] byArray, int n2) throws ShortBufferException {
        if (byArray.length - n2 < this.getUpdateOutputSize(n)) {
            throw new ShortBufferException("Expected a buffer of at least " + this.engineGetOutputSize(n) + " bytes; got " + (byArray.length - n2));
        }
    }

    private void checkArrayLimits(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative offset or length");
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Requested range is outside of buffer limits");
        }
    }

    private void lazyInit() {
        if (this.contextInitialized) {
            return;
        }
        this.contextInitialized = true;
        if (this.opMode < 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.checkNeedReset();
        if (this.context != null) {
            this.context.useVoid(l -> AesGcmSpi.encryptInit(l, this.iv));
        } else {
            long l2 = AesGcmSpi.encryptInit(this.key, this.iv);
            this.context = new NativeContext(l2);
        }
    }

    private void checkNeedReset() {
        if (this.needReset) {
            throw new IllegalStateException("Must change key or IV for GCM mode encryption");
        }
    }

    private void stateReset() {
        this.decryptInputBuf = null;
        if (this.opMode == 0) {
            this.decryptInputBuf = new AccessibleByteArrayOutputStream();
            this.decryptAADBuf = new AccessibleByteArrayOutputStream();
        }
        this.hasConsumedData = false;
        this.contextInitialized = false;
    }

    static {
        Loader.load();
    }

    private static class ShimArray {
        private final ByteBuffer backingBuffer;
        private final boolean doWriteback;
        public final byte[] array;
        public final int offset;
        public final int length;

        private ShimArray(ByteBuffer byteBuffer, int n) {
            byte[] byArray;
            this.backingBuffer = byteBuffer.duplicate();
            boolean bl = this.backingBuffer.hasArray();
            byte[] byArray2 = byArray = bl ? this.backingBuffer.array() : null;
            if (byArray == null) {
                byArray = new byte[n];
                this.backingBuffer.duplicate().get(byArray);
                this.doWriteback = true;
                this.offset = 0;
            } else {
                this.doWriteback = false;
                this.offset = this.backingBuffer.arrayOffset() + this.backingBuffer.position();
            }
            this.array = byArray;
            this.length = n;
        }

        private void writeback() {
            if (this.doWriteback) {
                this.backingBuffer.duplicate().put(this.array);
            }
        }
    }

    private static class NativeContext
    extends NativeResource {
        private NativeContext(long l2) {
            super(l2, (long l) -> AesGcmSpi.releaseContext(l));
        }
    }
}

