/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.SelfTestResult;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import com.amazon.corretto.crypto.provider.SelfTestSuite;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.Arrays;
import java.util.Scanner;
import java.util.logging.Logger;

public class AesCtrDrbg
extends SecureRandom {
    private static final String ALGORITHM_NAME = "NIST800-90A/AES-CTR-256";
    private static final long serialVersionUID = 1L;
    private static final int SEED_SIZE = 48;
    private static final int MAX_SINGLE_REQUEST = 8192;

    private static native long instantiate(byte[] var0, byte[] var1);

    private static native void reseed(long var0, byte[] var2);

    private static native void generate(long var0, byte[] var2, int var3, int var4);

    private static native void releaseState(long var0);

    public AesCtrDrbg() {
        super(new SPI(), AmazonCorrettoCryptoProvider.INSTANCE);
    }

    private AesCtrDrbg(byte[] byArray, byte[] byArray2) {
        super(new SPI(byArray, byArray2), AmazonCorrettoCryptoProvider.INSTANCE);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM_NAME;
    }

    static class SPI
    extends SecureRandomSpi {
        private static final long serialVersionUID = 1L;
        static final SelfTestSuite.SelfTest SELF_TEST = new SelfTestSuite.SelfTest("NIST800-90A/AES-CTR-256", SPI::runSelfTest);
        private static final ThreadLocal<NativeDrgbState> state_ = new ThreadLocal<NativeDrgbState>(){

            @Override
            protected NativeDrgbState initialValue() {
                return new NativeDrgbState(AesCtrDrbg.instantiate(null, null));
            }
        };
        private final NativeDrgbState testState_;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static SelfTestResult runSelfTest() {
            int n = 0;
            try (Scanner scanner = new Scanner(Loader.getTestData("ctr-drbg.txt"), StandardCharsets.US_ASCII.name());){
                byte[] byArray;
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4;
                do {
                    if (!scanner.hasNext()) return new SelfTestResult(SelfTestStatus.PASSED);
                    ++n;
                    int n2 = scanner.nextInt() / 8;
                    byArray2 = Utils.decodeHex(scanner.next());
                    byArray = Utils.decodeHex(scanner.next());
                    byArray4 = Utils.decodeHex(scanner.next());
                    AesCtrDrbg aesCtrDrbg = new AesCtrDrbg(byArray, byArray2);
                    byArray3 = new byte[n2];
                    aesCtrDrbg.nextBytes(byArray3);
                    aesCtrDrbg.nextBytes(byArray3);
                } while (Arrays.equals(byArray4, byArray3));
                SelfTestResult selfTestResult = new SelfTestResult((Throwable)((Object)new AssertionError((Object)String.format("Expected output did not match for inputs: (seed=%s, entropy=%s, expected=%s), actual=%s", SPI.encodeHex(byArray2), SPI.encodeHex(byArray), SPI.encodeHex(byArray4), SPI.encodeHex(byArray3)))));
                Logger.getLogger("AmazonCorrettoCryptoProvider").severe("NIST800-90A/AES-CTR-256 failed self-test " + n);
                SelfTestResult selfTestResult2 = selfTestResult;
                return selfTestResult2;
            }
            catch (Throwable throwable) {
                return new SelfTestResult(throwable);
            }
        }

        private static String encodeHex(byte[] byArray) {
            String string = "0123456789abcdef";
            StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
            for (byte by : byArray) {
                stringBuilder.append(string.charAt(by >> 4 & 0xF));
                stringBuilder.append(string.charAt(by & 0xF));
            }
            return stringBuilder.toString();
        }

        SPI() {
            this(null, null);
        }

        private SPI(byte[] byArray, byte[] byArray2) {
            boolean bl;
            Loader.checkNativeLibraryAvailability();
            if (!AmazonCorrettoCryptoProvider.isRdRandSupported()) {
                throw new UnsupportedOperationException("RDRAND not supported");
            }
            boolean bl2 = bl = byArray != null || byArray2 != null;
            if (bl) {
                this.testState_ = new NativeDrgbState(AesCtrDrbg.instantiate(byArray2, byArray));
            } else {
                this.testState_ = null;
                SELF_TEST.assertSelfTestPassed();
            }
        }

        private NativeDrgbState getState() {
            return this.testState_ != null ? this.testState_ : state_.get();
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            byte[] byArray = new byte[n];
            this.engineNextBytes(byArray);
            return byArray;
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            int n;
            for (int i = 0; i < byArray.length; i += n) {
                n = Math.min(8192, byArray.length - i);
                int n2 = i;
                this.getState().useVoid(l -> AesCtrDrbg.generate(l, byArray, n2, n));
            }
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
            byte[] byArray2 = byArray.length != 48 ? Arrays.copyOf(byArray, 48) : byArray;
            this.getState().useVoid(l -> AesCtrDrbg.reseed(l, byArray2));
        }

        private static class NativeDrgbState
        extends NativeResource {
            private NativeDrgbState(long l2) {
                super(l2, (long l) -> AesCtrDrbg.releaseState(l));
            }
        }
    }
}

