/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jsr303;

import java.util.Locale;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Session;
import org.wicketstuff.jsr303.ViolationMessageRenderer;
import org.wicketstuff.jsr303.util.Assert;

public class JSR303Validation {
    private static final JSR303Validation INSTANCE = new JSR303Validation();
    private static final MetaDataKey<ViolationMessageRenderer> violationMessageRendererKey = new MetaDataKey<ViolationMessageRenderer>(){
        private static final long serialVersionUID = 1L;
    };

    private synchronized ValidatorFactory createFactory() {
        Configuration configuration = Validation.byDefaultProvider().configure();
        ValidatorFactory validationFactory = configuration.messageInterpolator((MessageInterpolator)new WicketSessionLocaleMessageInterpolator(configuration.getDefaultMessageInterpolator())).buildValidatorFactory();
        return validationFactory;
    }

    public static final JSR303Validation getInstance() {
        return INSTANCE;
    }

    public static Validator getValidator() {
        return JSR303Validation.getInstance().createFactory().getValidator();
    }

    private JSR303Validation() {
    }

    static synchronized ViolationMessageRenderer getViolationMessageRenderer() {
        Application app = Application.get();
        ViolationMessageRenderer renderer = (ViolationMessageRenderer)app.getMetaData(violationMessageRendererKey);
        if (renderer == null) {
            renderer = new ViolationMessageRenderer.Default();
            JSR303Validation.setViolationMessageRenderer(renderer);
        }
        return renderer;
    }

    public static synchronized void setViolationMessageRenderer(ViolationMessageRenderer renderer) {
        Assert.parameterNotNull(renderer, "renderer");
        Application app = Application.get();
        app.setMetaData(violationMessageRendererKey, (Object)renderer);
    }

    public static class WicketSessionLocaleMessageInterpolator
    implements MessageInterpolator {
        private final MessageInterpolator delegate;

        public WicketSessionLocaleMessageInterpolator(MessageInterpolator delegate) {
            this.delegate = delegate;
            Assert.parameterNotNull(delegate, "delegate");
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            return this.delegate.interpolate(message, context, Session.get().getLocale());
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, Session.get().getLocale());
        }
    }
}

