/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.UnitilsException;
import org.unitils.thirdparty.org.apache.commons.io.IOUtils;

public class PropertiesReader {
    private static Log logger = LogFactory.getLog(PropertiesReader.class);

    public Properties loadPropertiesFileFromUserHome(String propertiesFileName) {
        FileInputStream inputStream = null;
        try {
            if ("".equals(propertiesFileName)) {
                throw new IllegalArgumentException("Properties Filename must be given.");
            }
            Properties properties = new Properties();
            String userHomeDir = System.getProperty("user.home");
            File localPropertiesFile = new File(userHomeDir, propertiesFileName);
            if (!localPropertiesFile.exists()) {
                Properties properties2 = null;
                return properties2;
            }
            inputStream = new FileInputStream(localPropertiesFile);
            properties.load(inputStream);
            logger.info((Object)("Loaded configuration file " + propertiesFileName + " from user home"));
            Properties properties3 = properties;
            IOUtils.closeQuietly(inputStream);
            return properties3;
        }
        catch (Exception e) {
            throw new UnitilsException("Unable to load configuration file: " + propertiesFileName + " from user home", e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public Properties loadPropertiesFileFromClasspath(String propertiesFileName) {
        Properties properties;
        Properties properties2;
        InputStream inputStream;
        block6: {
            inputStream = null;
            if ("".equals(propertiesFileName)) {
                throw new IllegalArgumentException("Properties Filename must be given.");
            }
            properties2 = new Properties();
            inputStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
            if (inputStream != null) break block6;
            Properties properties3 = null;
            IOUtils.closeQuietly(inputStream);
            return properties3;
        }
        try {
            properties2.load(inputStream);
            properties = properties2;
        }
        catch (Exception e) {
            try {
                throw new UnitilsException("Unable to load configuration file: " + propertiesFileName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return properties;
    }
}

