/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.strategy;

import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.android.Android23Instantiator;
import org.springframework.objenesis.instantiator.android.Android30Instantiator;
import org.springframework.objenesis.instantiator.gcj.GCJInstantiator;
import org.springframework.objenesis.instantiator.jrockit.JRockitLegacyInstantiator;
import org.springframework.objenesis.instantiator.perc.PercInstantiator;
import org.springframework.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import org.springframework.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import org.springframework.objenesis.strategy.BaseInstantiatorStrategy;
import org.springframework.objenesis.strategy.PlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("BEA")) {
            if (!(!VM_VERSION.startsWith("1.4") || VENDOR_VERSION.startsWith("R") || VM_INFO != null && VM_INFO.startsWith("R25.1") && VM_INFO.startsWith("R25.2"))) {
                return new JRockitLegacyInstantiator<T>(type);
            }
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (VENDOR_VERSION.compareTo("1.5.0") < 0) {
                return new Android23Instantiator<T>(type);
            }
            return new Android30Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

