/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.saaj.SaajSoapElement;
import org.springframework.ws.soap.saaj.SaajSoapHeaderElement;
import org.springframework.ws.soap.saaj.SaajSoapHeaderException;
import org.w3c.dom.Node;

abstract class SaajSoapHeader
extends SaajSoapElement<SOAPHeader>
implements SoapHeader {
    SaajSoapHeader(SOAPHeader header) {
        super(header);
    }

    @Override
    public Iterator<SoapHeaderElement> examineAllHeaderElements() throws SoapHeaderException {
        Iterator iterator = this.getSaajHeader().examineAllHeaderElements();
        return new SaajSoapHeaderElementIterator(iterator);
    }

    @Override
    public Iterator<SoapHeaderElement> examineHeaderElements(QName name) throws SoapHeaderException {
        Iterator iterator = this.getSaajHeader().getChildElements(name);
        return new SaajSoapHeaderElementIterator(iterator);
    }

    @Override
    public Iterator<SoapHeaderElement> examineMustUnderstandHeaderElements(String actorOrRole) throws SoapHeaderException {
        Iterator iterator = this.getSaajHeader().examineMustUnderstandHeaderElements(actorOrRole);
        return new SaajSoapHeaderElementIterator(iterator);
    }

    @Override
    public SoapHeaderElement addHeaderElement(QName name) throws SoapHeaderException {
        try {
            SOAPHeaderElement headerElement = this.getSaajHeader().addHeaderElement(name);
            return new SaajSoapHeaderElement(headerElement);
        }
        catch (SOAPException ex) {
            throw new SaajSoapHeaderException(ex);
        }
    }

    @Override
    public void removeHeaderElement(QName name) throws SoapHeaderException {
        Iterator iterator = this.getSaajHeader().getChildElements(name);
        if (iterator.hasNext()) {
            SOAPElement element = (SOAPElement)iterator.next();
            element.detachNode();
        }
    }

    protected SOAPHeader getSaajHeader() {
        return (SOAPHeader)this.getSaajElement();
    }

    @Override
    public Result getResult() {
        return new DOMResult((Node)this.getSaajHeader());
    }

    protected static class SaajSoapHeaderElementIterator
    implements Iterator<SoapHeaderElement> {
        private final Iterator<SOAPHeaderElement> iterator;

        protected SaajSoapHeaderElementIterator(Iterator<SOAPHeaderElement> iterator) {
            Assert.notNull(iterator, (String)"iterator must not be null");
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SoapHeaderElement next() {
            SOAPHeaderElement saajHeaderElement = this.iterator.next();
            return new SaajSoapHeaderElement(saajHeaderElement);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

