/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.approval;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.util.Assert;

public class TokenStoreUserApprovalHandler
implements UserApprovalHandler,
InitializingBean {
    private static Log logger = LogFactory.getLog(TokenStoreUserApprovalHandler.class);
    private String approvalParameter = "user_oauth_approval";
    private TokenStore tokenStore;
    private ClientDetailsService clientDetailsService;
    private OAuth2RequestFactory requestFactory;

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    public void setApprovalParameter(String approvalParameter) {
        this.approvalParameter = approvalParameter;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setRequestFactory(OAuth2RequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.tokenStore != null ? 1 : 0) != 0, (String)"TokenStore must be provided");
        Assert.state((this.requestFactory != null ? 1 : 0) != 0, (String)"OAuth2RequestFactory must be provided");
    }

    @Override
    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest.isApproved();
    }

    @Override
    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean approved = false;
        String clientId = authorizationRequest.getClientId();
        Set scopes = authorizationRequest.getScope();
        if (this.clientDetailsService != null) {
            try {
                ClientDetails client = this.clientDetailsService.loadClientByClientId(clientId);
                approved = true;
                for (String scope : scopes) {
                    if (client.isAutoApprove(scope)) continue;
                    approved = false;
                }
                if (approved) {
                    authorizationRequest.setApproved(true);
                    return authorizationRequest;
                }
            }
            catch (ClientRegistrationException e) {
                logger.warn((Object)("Client registration problem prevent autoapproval check for client=" + clientId));
            }
        }
        OAuth2Request storedOAuth2Request = this.requestFactory.createOAuth2Request(authorizationRequest);
        OAuth2Authentication authentication = new OAuth2Authentication(storedOAuth2Request, userAuthentication);
        if (logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Looking up existing token for ");
            builder.append("client_id=" + clientId);
            builder.append(", scope=" + scopes);
            builder.append(" and username=" + userAuthentication.getName());
            logger.debug((Object)builder.toString());
        }
        OAuth2AccessToken accessToken = this.tokenStore.getAccessToken(authentication);
        logger.debug((Object)("Existing access token=" + accessToken));
        if (accessToken != null && !accessToken.isExpired()) {
            logger.debug((Object)("User already approved with token=" + accessToken));
            approved = true;
        } else {
            logger.debug((Object)"Checking explicit approval");
            approved = userAuthentication.isAuthenticated() && approved;
        }
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }

    @Override
    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Map<String, String> approvalParameters = authorizationRequest.getApprovalParameters();
        String flag = approvalParameters.get(this.approvalParameter);
        boolean approved = flag != null && flag.toLowerCase().equals("true");
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }

    @Override
    public Map<String, Object> getUserApprovalRequest(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(authorizationRequest.getRequestParameters());
        return model;
    }
}

