/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldTypeRequiredException;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.SubsectionDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class XmlContentHandler
implements ContentHandler {
    private final DocumentBuilder documentBuilder;
    private final byte[] rawContent;

    XmlContentHandler(byte[] rawContent) {
        try {
            this.documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Failed to create document builder", ex);
        }
        this.rawContent = rawContent;
        this.readPayload();
    }

    @Override
    public List<FieldDescriptor> findMissingFields(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldDescriptor> missingFields = new ArrayList<FieldDescriptor>();
        Document payload = this.readPayload();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            NodeList matchingNodes;
            if (fieldDescriptor.isOptional() || (matchingNodes = this.findMatchingNodes(fieldDescriptor, payload)).getLength() != 0) continue;
            missingFields.add(fieldDescriptor);
        }
        return missingFields;
    }

    private NodeList findMatchingNodes(FieldDescriptor fieldDescriptor, Document payload) {
        try {
            return (NodeList)this.createXPath(fieldDescriptor.getPath()).evaluate(payload, XPathConstants.NODESET);
        }
        catch (XPathExpressionException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private Document readPayload() {
        try {
            return this.documentBuilder.parse(new InputSource(new ByteArrayInputStream(this.rawContent)));
        }
        catch (Exception ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private XPathExpression createXPath(String fieldPath) throws XPathExpressionException {
        return XPathFactory.newInstance().newXPath().compile(fieldPath);
    }

    @Override
    public String getUndocumentedContent(List<FieldDescriptor> fieldDescriptors) {
        Document payload = this.readPayload();
        ArrayList<Node> matchedButNotRemoved = new ArrayList<Node>();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            NodeList matchingNodes;
            try {
                matchingNodes = (NodeList)this.createXPath(fieldDescriptor.getPath()).evaluate(payload, XPathConstants.NODESET);
            }
            catch (XPathExpressionException ex) {
                throw new PayloadHandlingException(ex);
            }
            for (int i = 0; i < matchingNodes.getLength(); ++i) {
                Node node = matchingNodes.item(i);
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    attr.getOwnerElement().removeAttributeNode(attr);
                    continue;
                }
                if (fieldDescriptor instanceof SubsectionDescriptor || this.isLeafNode(node)) {
                    node.getParentNode().removeChild(node);
                    continue;
                }
                matchedButNotRemoved.add(node);
            }
        }
        this.removeLeafNodes(matchedButNotRemoved);
        if (payload.getChildNodes().getLength() > 0) {
            return this.prettyPrint(payload);
        }
        return null;
    }

    private void removeLeafNodes(List<Node> candidates) {
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator<Node> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                if (!this.isLeafNode(node)) continue;
                node.getParentNode().removeChild(node);
                iterator.remove();
                changed = true;
            }
        }
    }

    private boolean isLeafNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!(childNodes.item(i) instanceof Element)) continue;
            return false;
        }
        return true;
    }

    private String prettyPrint(Document document) {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    @Override
    public Object resolveFieldType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() != null) {
            return fieldDescriptor.getType();
        }
        throw new FieldTypeRequiredException("The type of a field in an XML payload cannot be determined automatically. Please provide a type using FieldDescriptor.type(Object type)");
    }
}

