/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.JsonFieldTypes;

class JsonFieldTypesDiscoverer {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();

    JsonFieldTypesDiscoverer() {
    }

    JsonFieldTypes discoverFieldTypes(String path, Object payload) {
        JsonFieldProcessor.ExtractedField extractedField = this.fieldProcessor.extract(path, payload);
        Object value = extractedField.getValue();
        if (value instanceof Collection && extractedField.getType() == JsonFieldPath.PathType.MULTI) {
            Collection values = (Collection)value;
            if (this.allAbsent(values)) {
                throw new FieldDoesNotExistException(path);
            }
            HashSet<JsonFieldType> fieldTypes = new HashSet<JsonFieldType>();
            for (Object item : values) {
                fieldTypes.add(this.determineFieldType(item));
            }
            return new JsonFieldTypes(fieldTypes);
        }
        if (value == JsonFieldProcessor.ExtractedField.ABSENT) {
            throw new FieldDoesNotExistException(path);
        }
        return new JsonFieldTypes(this.determineFieldType(value));
    }

    private JsonFieldType determineFieldType(Object fieldValue) {
        if (fieldValue == null || fieldValue == JsonFieldProcessor.ExtractedField.ABSENT) {
            return JsonFieldType.NULL;
        }
        if (fieldValue instanceof String) {
            return JsonFieldType.STRING;
        }
        if (fieldValue instanceof Map) {
            return JsonFieldType.OBJECT;
        }
        if (fieldValue instanceof Collection) {
            return JsonFieldType.ARRAY;
        }
        if (fieldValue instanceof Boolean) {
            return JsonFieldType.BOOLEAN;
        }
        return JsonFieldType.NUMBER;
    }

    private boolean allAbsent(Collection<?> values) {
        for (Object value : values) {
            if (value == JsonFieldProcessor.ExtractedField.ABSENT) continue;
            return false;
        }
        return true;
    }
}

