/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class JsonFieldPaths {
    private final Set<String> uncommonFieldPaths;

    private JsonFieldPaths(Set<String> uncommonFieldPaths) {
        this.uncommonFieldPaths = uncommonFieldPaths;
    }

    Set<String> getUncommon() {
        return this.uncommonFieldPaths;
    }

    static JsonFieldPaths from(Collection<?> items) {
        HashSet<LinkedHashSet<String>> itemsFieldPaths = new HashSet<LinkedHashSet<String>>();
        HashSet<String> allFieldPaths = new HashSet<String>();
        for (Object item : items) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            JsonFieldPaths.from(linkedHashSet, "", item);
            itemsFieldPaths.add(linkedHashSet);
            allFieldPaths.addAll(linkedHashSet);
        }
        HashSet<String> uncommonFieldPaths = new HashSet<String>();
        for (Set set : itemsFieldPaths) {
            HashSet uncommonForItem = new HashSet(allFieldPaths);
            uncommonForItem.removeAll(set);
            uncommonFieldPaths.addAll(uncommonForItem);
        }
        return new JsonFieldPaths(uncommonFieldPaths);
    }

    private static void from(Set<String> paths, String parent, Object object) {
        if (object instanceof List) {
            String path = JsonFieldPaths.append(parent, "[]");
            paths.add(path);
            JsonFieldPaths.from(paths, path, (List)object);
        } else if (object instanceof Map) {
            JsonFieldPaths.from(paths, parent, (Map)object);
        }
    }

    private static void from(Set<String> paths, String parent, List<?> items) {
        for (Object item : items) {
            JsonFieldPaths.from(paths, parent, item);
        }
    }

    private static void from(Set<String> paths, String parent, Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String path = JsonFieldPaths.append(parent, entry.getKey());
            paths.add(path);
            JsonFieldPaths.from(paths, path, entry.getValue());
        }
    }

    private static String append(String path, Object suffix) {
        return path.length() == 0 ? "" + suffix : path + "." + suffix;
    }
}

