/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.restdocs.payload.JsonFieldPaths;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;

public class FieldPathPayloadSubsectionExtractor
implements PayloadSubsectionExtractor<FieldPathPayloadSubsectionExtractor> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final ObjectMapper prettyPrintingOjectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final String fieldPath;
    private final String subsectionId;

    protected FieldPathPayloadSubsectionExtractor(String fieldPath) {
        this(fieldPath, "beneath-" + fieldPath);
    }

    protected FieldPathPayloadSubsectionExtractor(String fieldPath, String subsectionId) {
        this.fieldPath = fieldPath;
        this.subsectionId = subsectionId;
    }

    @Override
    public byte[] extractSubsection(byte[] payload, MediaType contentType) {
        try {
            JsonFieldProcessor.ExtractedField extractedField = new JsonFieldProcessor().extract(this.fieldPath, objectMapper.readValue(payload, Object.class));
            Object value = extractedField.getValue();
            if (value instanceof List) {
                List extractedList = (List)value;
                Set<String> uncommonPaths = JsonFieldPaths.from(extractedList).getUncommon();
                if (uncommonPaths.isEmpty()) {
                    value = extractedList.get(0);
                } else {
                    String message = this.fieldPath + " identifies multiple sections of the payload and they do not have a common structure. The following uncommon paths were found: ";
                    ArrayList<String> prefixedPaths = new ArrayList<String>();
                    for (String uncommonPath : uncommonPaths) {
                        prefixedPaths.add(this.fieldPath + "." + uncommonPath);
                    }
                    message = message + prefixedPaths;
                    throw new PayloadHandlingException(message);
                }
            }
            return this.getObjectMapper(payload).writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    @Override
    public String getSubsectionId() {
        return this.subsectionId;
    }

    protected String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public FieldPathPayloadSubsectionExtractor withSubsectionId(String subsectionId) {
        return new FieldPathPayloadSubsectionExtractor(this.fieldPath, subsectionId);
    }

    private ObjectMapper getObjectMapper(byte[] payload) {
        if (this.isPrettyPrinted(payload)) {
            return prettyPrintingOjectMapper;
        }
        return objectMapper;
    }

    private boolean isPrettyPrinted(byte[] payload) {
        for (byte b : payload) {
            if (b != 10) continue;
            return true;
        }
        return false;
    }
}

