/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldTypeResolver;
import org.springframework.restdocs.payload.JsonContentHandler;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.XmlContentHandler;

interface ContentHandler
extends FieldTypeResolver {
    public List<FieldDescriptor> findMissingFields(List<FieldDescriptor> var1);

    public String getUndocumentedContent(List<FieldDescriptor> var1);

    public static ContentHandler forContent(byte[] content, MediaType contentType) {
        try {
            return new JsonContentHandler(content);
        }
        catch (Exception je) {
            try {
                return new XmlContentHandler(content);
            }
            catch (Exception xe) {
                throw new PayloadHandlingException("Cannot handle " + contentType + " content as it could not be parsed as JSON or XML");
            }
        }
    }
}

