/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.Operation;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.FieldTypeRequiredException;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;
import org.springframework.restdocs.payload.SubsectionDescriptor;
import org.springframework.restdocs.snippet.Attributes;
import org.springframework.restdocs.snippet.ModelCreationException;
import org.springframework.restdocs.snippet.SnippetException;
import org.springframework.restdocs.snippet.TemplatedSnippet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractFieldsSnippet
extends TemplatedSnippet {
    private final List<FieldDescriptor> fieldDescriptors;
    private final boolean ignoreUndocumentedFields;
    private final String type;
    private final PayloadSubsectionExtractor<?> subsectionExtractor;

    protected AbstractFieldsSnippet(String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        this(type, type, descriptors, attributes, ignoreUndocumentedFields);
    }

    protected AbstractFieldsSnippet(String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields, PayloadSubsectionExtractor<?> subsectionExtractor) {
        this(type, type, descriptors, attributes, ignoreUndocumentedFields, subsectionExtractor);
    }

    protected AbstractFieldsSnippet(String name, String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields) {
        this(name, type, descriptors, attributes, ignoreUndocumentedFields, null);
    }

    protected AbstractFieldsSnippet(String name, String type, List<FieldDescriptor> descriptors, Map<String, Object> attributes, boolean ignoreUndocumentedFields, PayloadSubsectionExtractor<?> subsectionExtractor) {
        super(name + "-fields" + (subsectionExtractor != null ? "-" + subsectionExtractor.getSubsectionId() : ""), type + "-fields", attributes);
        for (FieldDescriptor descriptor : descriptors) {
            Assert.notNull((Object)descriptor.getPath(), (String)"Field descriptors must have a path");
            if (descriptor.isIgnored()) continue;
            Assert.notNull((Object)(descriptor.getDescription() != null ? 1 : 0), (String)("The descriptor for '" + descriptor.getPath() + "' must have a description or it must be marked as ignored"));
        }
        this.fieldDescriptors = descriptors;
        this.ignoreUndocumentedFields = ignoreUndocumentedFields;
        this.type = type;
        this.subsectionExtractor = subsectionExtractor;
    }

    @Override
    protected Map<String, Object> createModel(Operation operation) {
        byte[] content;
        try {
            content = this.verifyContent(this.getContent(operation));
        }
        catch (IOException ex) {
            throw new ModelCreationException(ex);
        }
        MediaType contentType = this.getContentType(operation);
        if (this.subsectionExtractor != null) {
            content = this.verifyContent(this.subsectionExtractor.extractSubsection(content, contentType));
        }
        ContentHandler contentHandler = ContentHandler.forContent(content, contentType);
        this.validateFieldDocumentation(contentHandler);
        ArrayList<FieldDescriptor> descriptorsToDocument = new ArrayList<FieldDescriptor>();
        for (FieldDescriptor descriptor : this.fieldDescriptors) {
            if (descriptor.isIgnored()) continue;
            try {
                Object type = contentHandler.resolveFieldType(descriptor);
                descriptorsToDocument.add(this.copyWithType(descriptor, type));
            }
            catch (FieldDoesNotExistException ex) {
                String message = "Cannot determine the type of the field '" + descriptor.getPath() + "' as it is not present in the payload. Please provide a type using FieldDescriptor.type(Object type).";
                throw new FieldTypeRequiredException(message);
            }
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        model.put("fields", fields);
        for (FieldDescriptor descriptor : descriptorsToDocument) {
            if (descriptor.isIgnored()) continue;
            fields.add(this.createModelForDescriptor(descriptor));
        }
        return model;
    }

    private byte[] verifyContent(byte[] content) {
        if (content.length == 0) {
            throw new SnippetException("Cannot document " + this.type + " fields as the " + this.type + " body is empty");
        }
        return content;
    }

    private void validateFieldDocumentation(ContentHandler payloadHandler) {
        String undocumentedPayload;
        List<FieldDescriptor> missingFields = payloadHandler.findMissingFields(this.fieldDescriptors);
        String string = undocumentedPayload = this.ignoreUndocumentedFields ? null : payloadHandler.getUndocumentedContent(this.fieldDescriptors);
        if (!missingFields.isEmpty() || StringUtils.hasText((String)undocumentedPayload)) {
            String message = "";
            if (StringUtils.hasText((String)undocumentedPayload)) {
                message = message + String.format("The following parts of the payload were not documented:%n%s", undocumentedPayload);
            }
            if (!missingFields.isEmpty()) {
                if (message.length() > 0) {
                    message = message + String.format("%n", new Object[0]);
                }
                ArrayList<String> paths = new ArrayList<String>();
                for (FieldDescriptor fieldDescriptor : missingFields) {
                    paths.add(fieldDescriptor.getPath());
                }
                message = message + "Fields with the following paths were not found in the payload: " + paths;
            }
            throw new SnippetException(message);
        }
    }

    protected abstract MediaType getContentType(Operation var1);

    protected abstract byte[] getContent(Operation var1) throws IOException;

    protected final List<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors;
    }

    protected final boolean isIgnoredUndocumentedFields() {
        return this.ignoreUndocumentedFields;
    }

    protected final PayloadSubsectionExtractor<?> getSubsectionExtractor() {
        return this.subsectionExtractor;
    }

    protected Map<String, Object> createModelForDescriptor(FieldDescriptor descriptor) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("path", descriptor.getPath());
        model.put("type", descriptor.getType().toString());
        model.put("description", descriptor.getDescription());
        model.put("optional", descriptor.isOptional());
        model.putAll(descriptor.getAttributes());
        return model;
    }

    private FieldDescriptor copyWithType(FieldDescriptor source, Object type) {
        FieldDescriptor result = source instanceof SubsectionDescriptor ? new SubsectionDescriptor(source.getPath()) : new FieldDescriptor(source.getPath());
        ((FieldDescriptor)result.description(source.getDescription())).type(type).attributes(AbstractFieldsSnippet.asArray(source.getAttributes()));
        if (source.isIgnored()) {
            result.ignored();
        }
        if (source.isOptional()) {
            result.optional();
        }
        return result;
    }

    private static Attributes.Attribute[] asArray(Map<String, Object> attributeMap) {
        ArrayList<Attributes.Attribute> attributes = new ArrayList<Attributes.Attribute>();
        for (Map.Entry<String, Object> attribute : attributeMap.entrySet()) {
            attributes.add(Attributes.key(attribute.getKey()).value(attribute.getValue()));
        }
        return attributes.toArray(new Attributes.Attribute[attributes.size()]);
    }
}

