/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation.preprocess;

import java.util.List;
import org.springframework.restdocs.operation.OperationResponse;
import org.springframework.restdocs.operation.preprocess.OperationPreprocessor;
import org.springframework.restdocs.operation.preprocess.OperationResponsePreprocessor;
import org.springframework.util.Assert;

class DelegatingOperationResponsePreprocessor
implements OperationResponsePreprocessor {
    private final List<OperationPreprocessor> delegates;

    DelegatingOperationResponsePreprocessor(List<OperationPreprocessor> delegates) {
        Assert.notNull(delegates, (String)"delegates must be non-null");
        this.delegates = delegates;
    }

    @Override
    public OperationResponse preprocess(OperationResponse response) {
        OperationResponse preprocessedResponse = response;
        for (OperationPreprocessor delegate : this.delegates) {
            preprocessedResponse = delegate.preprocess(preprocessedResponse);
        }
        return preprocessedResponse;
    }
}

