/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.cli;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.util.Base64Utils;

final class CliOperationRequest
implements OperationRequest {
    private final Set<HeaderFilter> headerFilters;
    private final OperationRequest delegate;

    CliOperationRequest(OperationRequest delegate) {
        this.delegate = delegate;
        this.headerFilters = new HashSet<HeaderFilter>(Arrays.asList(new NamedHeaderFilter("Content-Length"), new BasicAuthHeaderFilter(), new HostHeaderFilter(delegate.getUri())));
    }

    boolean isPutOrPost() {
        return HttpMethod.PUT.equals((Object)this.delegate.getMethod()) || HttpMethod.POST.equals((Object)this.delegate.getMethod());
    }

    String getBasicAuthCredentials() {
        List headerValue = this.delegate.getHeaders().get((Object)"Authorization");
        if (BasicAuthHeaderFilter.isBasicAuthHeader(headerValue)) {
            return BasicAuthHeaderFilter.decodeBasicAuthHeader(headerValue);
        }
        return null;
    }

    @Override
    public byte[] getContent() {
        return this.delegate.getContent();
    }

    @Override
    public String getContentAsString() {
        return this.delegate.getContentAsString();
    }

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders filteredHeaders = new HttpHeaders();
        for (Map.Entry header : this.delegate.getHeaders().entrySet()) {
            if (!this.allowedHeader(header)) continue;
            filteredHeaders.put((String)header.getKey(), (List)header.getValue());
        }
        return HttpHeaders.readOnlyHttpHeaders((HttpHeaders)filteredHeaders);
    }

    private boolean allowedHeader(Map.Entry<String, List<String>> header) {
        String value;
        for (HeaderFilter headerFilter : this.headerFilters) {
            if (headerFilter.allow(header.getKey(), header.getValue())) continue;
            return false;
        }
        return !"Host".equalsIgnoreCase(header.getKey()) || header.getValue().isEmpty() || !(value = header.getValue().get(0)).equals(this.delegate.getUri().getHost() + ":" + this.delegate.getUri().getPort());
    }

    @Override
    public HttpMethod getMethod() {
        return this.delegate.getMethod();
    }

    @Override
    public Parameters getParameters() {
        return this.delegate.getParameters();
    }

    @Override
    public Collection<OperationRequestPart> getParts() {
        return this.delegate.getParts();
    }

    @Override
    public URI getUri() {
        return this.delegate.getUri();
    }

    @Override
    public Collection<RequestCookie> getCookies() {
        return this.delegate.getCookies();
    }

    private static final class HostHeaderFilter
    implements HeaderFilter {
        private final URI uri;

        private HostHeaderFilter(URI uri) {
            this.uri = uri;
        }

        @Override
        public boolean allow(String name, List<String> value) {
            return !value.isEmpty() && !this.getImplicitHostHeader().equals(value.get(0));
        }

        private String getImplicitHostHeader() {
            return this.uri.getHost() + (this.uri.getPort() == -1 ? "" : ":" + this.uri.getPort());
        }
    }

    private static final class NamedHeaderFilter
    implements HeaderFilter {
        private final String name;

        NamedHeaderFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean allow(String name, List<String> value) {
            return !this.name.equalsIgnoreCase(name);
        }
    }

    private static final class BasicAuthHeaderFilter
    implements HeaderFilter {
        private BasicAuthHeaderFilter() {
        }

        @Override
        public boolean allow(String name, List<String> value) {
            return !"Authorization".equals(name) || !BasicAuthHeaderFilter.isBasicAuthHeader(value);
        }

        static boolean isBasicAuthHeader(List<String> value) {
            return value != null && !value.isEmpty() && value.get(0).startsWith("Basic ");
        }

        static String decodeBasicAuthHeader(List<String> value) {
            return new String(Base64Utils.decodeFromString((String)value.get(0).substring(6)));
        }
    }

    private static interface HeaderFilter {
        public boolean allow(String var1, List<String> var2);
    }
}

