/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.springframework.restdocs.ManualRestDocumentation;
import org.springframework.restdocs.RestDocumentationContextProvider;

public class RestDocumentationExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public void beforeEach(ExtensionContext context) throws Exception {
        this.getDelegate(context).beforeTest(context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.getDelegate(context).afterTest();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        if (this.isTestMethodContext(extensionContext)) {
            return RestDocumentationContextProvider.class.isAssignableFrom(parameterContext.getParameter().getType());
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        return () -> this.getDelegate(context).beforeOperation();
    }

    private boolean isTestMethodContext(ExtensionContext context) {
        return context.getTestClass().isPresent() && context.getTestMethod().isPresent();
    }

    private ManualRestDocumentation getDelegate(ExtensionContext context) {
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context.getUniqueId()});
        return (ManualRestDocumentation)context.getStore(namespace).getOrComputeIfAbsent(ManualRestDocumentation.class, key -> new ManualRestDocumentation(), ManualRestDocumentation.class);
    }
}

