/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Collection;
import java.util.Map;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;

class JsonFieldTypeResolver {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();

    JsonFieldTypeResolver() {
    }

    JsonFieldType resolveFieldType(FieldDescriptor fieldDescriptor, Object payload) {
        JsonFieldProcessor.ExtractedField extractedField = this.fieldProcessor.extract(fieldDescriptor.getPath(), payload);
        Object value = extractedField.getValue();
        if (value instanceof Collection && extractedField.getType() == JsonFieldPath.PathType.MULTI) {
            JsonFieldType commonType = null;
            for (Object item : (Collection)value) {
                JsonFieldType fieldType = this.determineFieldType(item);
                if (commonType == null) {
                    commonType = fieldType;
                    continue;
                }
                if (fieldType == commonType) continue;
                if (!fieldDescriptor.isOptional()) {
                    return JsonFieldType.VARIES;
                }
                if (commonType == JsonFieldType.NULL) {
                    commonType = fieldType;
                    continue;
                }
                if (fieldType == JsonFieldType.NULL) continue;
                return JsonFieldType.VARIES;
            }
            return commonType;
        }
        return this.determineFieldType(value);
    }

    private JsonFieldType determineFieldType(Object fieldValue) {
        if (fieldValue == null) {
            return JsonFieldType.NULL;
        }
        if (fieldValue instanceof String) {
            return JsonFieldType.STRING;
        }
        if (fieldValue instanceof Map) {
            return JsonFieldType.OBJECT;
        }
        if (fieldValue instanceof Collection) {
            return JsonFieldType.ARRAY;
        }
        if (fieldValue instanceof Boolean) {
            return JsonFieldType.BOOLEAN;
        }
        return JsonFieldType.NUMBER;
    }
}

