/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.operation;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.operation.QueryStringParser;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

public class Parameters
extends LinkedMultiValueMap<String, String> {
    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) {
                Parameters.append(sb, (String)entry.getKey());
                continue;
            }
            for (String value : (List)entry.getValue()) {
                Parameters.append(sb, (String)entry.getKey(), value);
            }
        }
        return sb.toString();
    }

    public Parameters getUniqueParameters(URI uri) {
        Parameters queryStringParameters = new QueryStringParser().parse(uri);
        Parameters uniqueParameters = new Parameters();
        for (Map.Entry parameter : this.entrySet()) {
            this.addIfUnique(parameter, queryStringParameters, uniqueParameters);
        }
        return uniqueParameters;
    }

    private void addIfUnique(Map.Entry<String, List<String>> parameter, Parameters queryStringParameters, Parameters uniqueParameters) {
        if (!queryStringParameters.containsKey(parameter.getKey())) {
            uniqueParameters.put(parameter.getKey(), parameter.getValue());
        } else {
            List<String> candidates = parameter.getValue();
            List existing = queryStringParameters.get(parameter.getKey());
            for (String candidate : candidates) {
                if (existing.contains(candidate)) continue;
                uniqueParameters.add(parameter.getKey(), candidate);
            }
        }
    }

    private static void append(StringBuilder sb, String key) {
        Parameters.append(sb, key, "");
    }

    private static void append(StringBuilder sb, String key, String value) {
        Parameters.doAppend(sb, Parameters.urlEncodeUTF8(key) + "=" + Parameters.urlEncodeUTF8(value));
    }

    private static void doAppend(StringBuilder sb, String toAppend) {
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(toAppend);
    }

    private static String urlEncodeUTF8(String s) {
        if (!StringUtils.hasLength((String)s)) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unable to URL encode " + s + " using UTF-8", ex);
        }
    }
}

